import React from 'react';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { ClipsSeekbarTimeDisplay } from 'ui/player-types/clips/common/clips-seekbar-time-display';
import * as Timestamp from 'util/timestamp';

reactTest('ui | player-types | clips | common | clips-seekbar-time-display', function() {
    QUnit.test('spans have expected class names', function(assert) {
        const component = shallow(
            <ClipsSeekbarTimeDisplay />
        );

        assert.ok(component.hasClass('player-seek__time-container'), 'has containing class');
        assert.ok(component.childAt(0).hasClass('player-seek__time player-seek__time--total'), 'has inner wrapper');
    });

    QUnit.test('uses formatted current time and duration to show remaining time', function(assert) {
        const currentTime = 5;
        const duration = 300;

        const component = shallow(
            <ClipsSeekbarTimeDisplay
                currentTime={currentTime}
                duration={duration}
            />
        );

        assert.equal(
            component.childAt(0).text(), Timestamp.toString(duration - currentTime, true),
            'has the correct timestamp with a given currentTime and duration'
        );
    });
});
