import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import {
    BroadcasterPlayingGameLinkComponent,
} from 'ui/player-types/clips/overlays/clip-info-overlay/broadcaster-playing-game-link';
import { BroadcasterLink } from 'ui/player-types/clips/overlays/clip-info-overlay/broadcaster-link';
import { Interpolate } from 'react-i18next';

const DEFAULT_ARGS = Object.freeze({
    broadcasterDisplayName: 'broadcasterDisplayName',
    channelURL: 'channelURL',
    game: 'game',
    gameUrl: 'gameUrl',
});

function renderBroadcasterPlayingGameLink(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <BroadcasterPlayingGameLinkComponent {...args} />;
    return shallow(component);
}

reactTest('ui | clips-embed | clip-info-overlay | broadcaster-playing-game', function() {
    QUnit.test('renders a BroadcasterLink when there is no game', function(assert) {
        const component = renderBroadcasterPlayingGameLink({ game: null });
        assert.equal(component.find({ i18nKey: '{{displayName}} playing {{game}}' }).length, 0);
        assert.equal(component.type(), BroadcasterLink);
    });

    QUnit.test('renders a the boradcaster playing game when there is a game', function(assert) {
        const component = renderBroadcasterPlayingGameLink();
        assert.equal(component.find({ i18nKey: '{{displayName}} playing {{game}}' }).length, 1);
        assert.equal(component.type(), Interpolate);
    });
});
