import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import { ClipInfoOverlayComponent } from 'ui/player-types/clips/overlays/clip-info-overlay/clip-info-overlay';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';

const DEFAULT_ARGS = Object.freeze({
    logoUrl: 'logoUrl.com',
    title: 'title is the title',
    clipURL: 'clipURL.com',
    broadcasterDisplayName: 'broadcasterDisplayName',
    broadcasterLogin: 'broadcasterLogin',
    game: 'game-name',
    viewCount: 1500,
    t: mockTranslateFunc,
});

function renderClipOverlay(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <ClipInfoOverlayComponent {...args} />;
    return shallow(component);
}

reactTest('ui | clips-embed | clip-info-overlay', function() {
    QUnit.test('renders the title', function(assert) {
        const component = renderClipOverlay();
        assert.equal(component.find('.clip-userinfo__name').find('a').text(), DEFAULT_ARGS.title);
    });

    QUnit.test('renders the viewCount', function(assert) {
        const component = renderClipOverlay();

        assert.ok(component.text().includes('1,500 view'));
    });

    QUnit.test('pass the correct data to BroadcasterPlayingGameLink', function(assert) {
        const component = renderClipOverlay();
        const channelURL = `https://www.twitch.tv/${DEFAULT_ARGS.broadcasterLogin}/` +
            'clips?tt_content=player_channel_name&tt_medium=clips_embed';
        const gameUrl = `https://www.twitch.tv/directory/game/${DEFAULT_ARGS.game}/` +
            'clips?tt_content=player_game&tt_medium=clips_embed';
        const { game, broadcasterDisplayName } = DEFAULT_ARGS;

        assert.equal(component.find({
            channelURL,
            game,
            gameUrl,
            broadcasterDisplayName,
        }).length, 1);
    });
});
