import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import {
    ClipKeyboardShortcutsOverlayContainerComponent,
} from 'ui/player-types/clips/overlays/clip-keyboard-shortcuts-overlay/clip-keyboard-shortcuts-overlay-container';
import {
    ClipKeyboardShortcutsOverlay,
} from 'ui/player-types/clips/overlays/clip-keyboard-shortcuts-overlay/clip-keyboard-shortcuts-overlay';

const DEFAULT_ARGS = Object.freeze({
    shouldShowShortcutsPanel: true,
});

function renderClipOverlayContainer(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <ClipKeyboardShortcutsOverlayContainerComponent {...args} />;
    return shallow(component);
}

reactTest('ui | player-types | clips | overlays | clip-keyboard-shortcuts-overlay-container', function() {
    QUnit.test('renders the component', function(assert) {
        const component = renderClipOverlayContainer();
        assert.equal(component.find(ClipKeyboardShortcutsOverlay).length, 1);
    });

    QUnit.test('renders nothing when it should not show the component', function(assert) {
        const component = renderClipOverlayContainer({
            shouldShowShortcutsPanel: false,
        });
        assert.equal(component.find(ClipKeyboardShortcutsOverlay).length, 0);
    });
});
