import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import sinon from 'sinon';
import {
    ClipKeyboardShortcutsOverlayComponent,
} from 'ui/player-types/clips/overlays/clip-keyboard-shortcuts-overlay/clip-keyboard-shortcuts-overlay';
import { CloseButtonSVG } from 'ui/player-types/clips/common/svg/close-button';
import { ShortcutRow } from 'ui/player-types/clips/overlays/clip-keyboard-shortcuts-overlay/shortcut-row';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';

const DEFAULT_ARGS = Object.freeze({
    closeShortcutsPanel: () => {},
    t: mockTranslateFunc,
});

function renderClipOverlay(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <ClipKeyboardShortcutsOverlayComponent {...args} />;
    return shallow(component);
}

reactTest('ui | player-types | clips | overlays | clip-keyboard-shortcuts-overlay', function() {
    QUnit.test('renders the title', function(assert) {
        const component = renderClipOverlay();
        assert.equal(component.text().includes('Keyboard Shortcuts'), true);
    });

    QUnit.test('renders the close button', function(assert) {
        const component = renderClipOverlay();
        assert.equal(component.find(CloseButtonSVG).length, 1);
    });

    QUnit.test('calls the close function when close is clicked', function(assert) {
        const closeSpy = sinon.spy();
        const component = renderClipOverlay({
            closeShortcutsPanel: closeSpy,
        });

        assert.equal(closeSpy.callCount, 0, 'close was not clicked');

        component.find('button').simulate('click');

        assert.equal(closeSpy.callCount, 1, 'close was clicked');
    });

    QUnit.test('renders seven shortcuts', function(assert) {
        const component = renderClipOverlay();
        assert.equal(component.find(ShortcutRow).length, 7);
    });
});
