import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import {
    ClipShareOverlayComponent,
} from 'ui/player-types/clips/overlays/clip-share-overlay/clip-share-overlay';
import { ShareIcon } from 'ui/player-types/clips/overlays/clip-share-overlay/share-icon';
import { SelectableInput } from 'ui/player-types/clips/common/selectable-input';
import CopyToClipboard from 'react-copy-to-clipboard';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';

const DEFAULT_ARGS = Object.freeze({
    clipUrl: 'clipurl.clips.realurl.real.url.com',
    clipEmbedUrl: 'the-embed-version-of-the-url',
    t: mockTranslateFunc,
});

function renderClipShareOverlay(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <ClipShareOverlayComponent {...args} />;
    return shallow(component);
}

reactTest('ui | clips-embed | overlays | clip-share-overlay', function() {
    QUnit.test('defaults to show share buttons', function(assert) {
        const component = renderClipShareOverlay();
        assert.equal(component.find(ShareIcon).length, 3);
    });

    QUnit.test('defaults to show copy buttons and input', function(assert) {
        const component = renderClipShareOverlay();
        assert.equal(component.find(SelectableInput).length, 1);
        assert.equal(component.find(CopyToClipboard).length, 1);
    });

    QUnit.test('navigates to embed view on click', function(assert) {
        const component = renderClipShareOverlay();

        assert.equal(component.find({ label: 'Embed Code' }).length, 0);

        component.find('.cs-icon--embed').simulate('click');

        assert.equal(component.find({ label: 'Embed Code' }).length, 1);
    });
});
