import React from 'react';
import assign from 'lodash/assign';
import { reactTest } from 'tests/utils/react-test';
import { shallow } from 'enzyme';
import sinon from 'sinon';
import { ShareIconComponent } from 'ui/player-types/clips/overlays/clip-share-overlay/share-icon';
import { FacebookSVG } from 'ui/player-types/clips/common/svg/facebook';

const DEFAULT_ARGS = Object.freeze({
    companySVG: <FacebookSVG />,
    companyName: 'facebook',
    broadcaster: {},
    clipUrl: 'clipUrlBro',
    clipTitle: 'This might be the best clip.',
    localWindow: {
        open: () => {},
    },
});

function renderShareIcon(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <ShareIconComponent {...args} />;
    return shallow(component);
}

reactTest('ui | clips-embed | overlays | share-icon', function() {
    QUnit.test('shows the icon and is a button', function(assert) {
        const component = renderShareIcon();

        assert.equal(component.find(FacebookSVG).length, 1);
        assert.equal(component.find('.share-icon').length, 1);
    });

    QUnit.test('calls openShareWindow on click', function(assert) {
        const localWindowSpy = sinon.spy();
        const component = renderShareIcon({ localWindow: { open: localWindowSpy } });

        component.find('.share-icon').simulate('click');

        assert.ok(localWindowSpy.calledWith(
            `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(DEFAULT_ARGS.clipUrl)}%3Ftt_medium%3Dfb`,
            'Social Share',
            'status = 1, width = 560, height = 656, resizable = 0'
        ));
    });

    QUnit.test('calls onClick on click of button if passed', function(assert) {
        const onClickSpy = sinon.spy();
        const component = renderShareIcon({ onClick: onClickSpy });

        assert.equal(onClickSpy.callCount, 0, 'onClick is not called before click');

        component.find('.share-icon').simulate('click');

        assert.equal(onClickSpy.callCount, 1, 'onClick is called when passed');
    });
});
