import { unitTest } from 'tests/utils/module';
import { SocialLinkHelper, HASHTAG_CLIPS } from 'ui/player-types/clips/utils/social-link-helper';
import { mockTranslateFunc } from 'tests/utils/translate-hoc-helpers';

unitTest('ui | player-types | clips | social-link-helper', function(hooks) {
    let broadcaster;
    let rawTitle;
    let clipUrl;
    let broadcasterTwitter;
    let broadcasterDisplayName;

    hooks.beforeEach(function() {
        rawTitle = 'This CLIP is CLOPPING around CLAMMERING';
        clipUrl = 'http://clips-n-things.com';
        broadcasterTwitter = 'mlg_twitter';
        broadcasterDisplayName = 'mlg';

        broadcaster = {
            displayName: broadcasterDisplayName,
        };
    });

    QUnit.module('socialShareData', function() {
        QUnit.module('when title is empty', function(hooks) {
            let socialData;

            hooks.beforeEach(function() {
                rawTitle = '';
                socialData = SocialLinkHelper.getSocialShareData(
                    broadcaster,
                    clipUrl,
                    rawTitle,
                    mockTranslateFunc
                );
            });

            QUnit.module('facebook', function() {
                QUnit.test('should have the correct link', function(assert) {
                    assert.equal(socialData.facebook.url,
                        /* eslint-disable quotes */
                        `https://www.facebook.com/sharer/sharer.php?` +
                        `u=http%3A%2F%2Fclips-n-things.com%3Ftt_medium%3Dfb`
                        /* eslint-enable quotes */
                    );
                });
            });

            QUnit.module('twitter', function() {
                QUnit.test('should have the correct link', function(assert) {
                    assert.equal(socialData.twitter.url,
                        /* eslint-disable quotes */
                        `http://www.twitter.com/share?text=Check%20out%20this%20` +
                        `clip%20from%20mlg's%20broadcast%20%23twitchclips&url=` +
                        `http%3A%2F%2Fclips-n-things.com%3Ftt_medium%3Dtwtr`
                        /* eslint-enable quotes */
                    );
                });
            });

            QUnit.module('reddit', function() {
                QUnit.test('should have the correct link', function(assert) {
                    assert.equal(socialData.reddit.url,
                        /* eslint-disable quotes */
                        `http://www.reddit.com/submit?title=Check%20out%20this%20` +
                        `clip%20from%20mlg's%20broadcast&url=http%3A%2F%2Fclips-n-things.com%3Ftt_medium%3Dredt`
                        /* eslint-enable quotes */
                    );
                });
            });
        });

        QUnit.module('when title is not empty', function() {
            QUnit.test('should return the url with the title, not the expectedCaption', function(assert) {
                const socialData = SocialLinkHelper.getSocialShareData(
                    broadcaster,
                    clipUrl,
                    rawTitle,
                    mockTranslateFunc
                );
                assert.equal(socialData.twitter.url,
                    /* eslint-disable quotes */
                    `http://www.twitter.com/share?text=This%20CLIP%20is%20CLOPPING%20` +
                    `around%20CLAMMERING%20%23twitchclips&url=http%3A%2F%2Fclips-n-things.com%3Ftt_medium%3Dtwtr`
                    /* eslint-enable quotes */
                );
            });
        });
    });

    QUnit.module('generateTwitterSuffix', function() {
        QUnit.test('should return a properly formatted string', function(assert) {
            assert.equal(SocialLinkHelper.generateTwitterSuffix(broadcaster), ` ${HASHTAG_CLIPS} `);
        });

        QUnit.test('should include the Broadcaster\'s Twitter Handle when specified', function(assert) {
            broadcaster.twitterLogin = broadcasterTwitter;

            assert.equal(
                SocialLinkHelper.generateTwitterSuffix(broadcaster),
                ` ${HASHTAG_CLIPS} @${broadcaster.twitterLogin} `
            );
        });
    });
});
