import { unitTest } from 'tests/utils/module';
import { addIfNotPresent } from 'ui/player-types/clips/utils/state-helper';

unitTest('ui | player-types | clips | state-helper', function() {
    QUnit.module('addIfNotPresent', function() {
        QUnit.test('should add if the given item is not present', function(assert) {
            const arr = [1, 2, 3];

            assert.equal(addIfNotPresent(arr, 1), arr, 'handle addition that already exists');
            assert.deepEqual(addIfNotPresent(arr, 4), arr.concat([4]), 'handle new additions');
        });
    });
});
