import { unitTest } from 'tests/utils/module';
import { cleanCondense } from 'ui/player-types/clips/utils/string-formatter';

unitTest('ui | player-types | clips | string-formatter', function() {
    QUnit.module('cleanCondense', function() {
        QUnit.module('with no given max', function() {
            QUnit.test('should cut out all extra whitespace around words', function(assert) {
                assert.equal(cleanCondense(''), '');
                assert.equal(cleanCondense('\n\t\n\n\n\t'), '');
                assert.equal(cleanCondense(' hey    you '), 'hey you');
                assert.equal(cleanCondense(' hey \n\n\n\t\t\t   you '), 'hey you');
            });
        });

        QUnit.module('with a given max', function() {
            QUnit.test('should try to leave as much sensical data as possible', function(assert) {
                assert.equal(cleanCondense(' hey \n\n\n\t\t\t   you dude   ', 0), '');
                assert.equal(cleanCondense(' hey \n\n\n\t\t\t   you dude   ', 1), 'h');
                assert.equal(cleanCondense(' hey \n\n\n\t\t\t   you dude   ', 2), 'he');
                assert.equal(cleanCondense(' hey \n\n\n\t\t\t   you dude   ', 3), 'hey');
                assert.equal(cleanCondense(' hey \n\n\n\t\t\t   you dude   ', 4), 'hey');
                assert.equal(cleanCondense(' hey \n\n\n\t\t\t   you dude   ', 5), 'hey');
                assert.equal(cleanCondense(' hey \n\n\n\t\t\t   you dude   ', 6), 'hey');
                assert.equal(cleanCondense(' hey \n\n\n\t\t\t   you dude   ', 7), 'hey you');
                assert.equal(cleanCondense(' hey \n\n\n\t\t\t   you dude   ', 8), 'hey you');
                assert.equal(cleanCondense(' hey \n\n\n\t\t\t   you dude   ', 9), 'hey you');
                assert.equal(cleanCondense(' hey \n\n\n\t\t\t   you dude   ', 10), 'hey you');
                assert.equal(cleanCondense(' hey \n\n\n\t\t\t   you dude   ', 11), 'hey you');
                assert.equal(cleanCondense(' hey \n\n\n\t\t\t   you dude   ', 12), 'hey you dude');
                assert.equal(cleanCondense(' hey \n\n\n\t\t\t   you dude   ', 13), 'hey you dude');
            });

            QUnit.test('should leave off half words due to specific max', function(assert) {
                assert.equal(cleanCondense('1234 6789', 7), '1234');
            });

            QUnit.test('should leave a half word if the max would cut out all the words', function(assert) {
                assert.equal(cleanCondense('', 0), '');
                assert.equal(cleanCondense('123', 0), '');
                assert.equal(cleanCondense('123', 1), '1');
                assert.equal(cleanCondense('123', 2), '12');
                assert.equal(cleanCondense('123', 3), '123');
                assert.equal(cleanCondense('123', 4), '123');
            });
        });
    });
});
