import { unitTest } from 'tests/utils/module';
import { LOGGED_IN } from 'state/user';
import { buildFakeWindow } from 'tests/fakes/window.fake';
import {
    clipsBaseProperties,
    clipsClipProperties,
    TRACKING_VOD_TYPE,
} from 'ui/player-types/clips/utils/tracking/base-properties';
import { clipStreamMetadata } from 'tests/fixtures/clip';
import { PLAYER_CLIPS_EMBED } from 'util/player-type';
import { TAB_SESSION_ID_KEY } from 'ui/player-types/clips/utils/tracking/tab-session-id';
import { DEFAULT_BROADCASTER_INFO } from 'state/broadcaster-info';
import { TRACKING_MEDIUM_EMBED } from 'ui/player-types/clips/utils/tracking/clips-tracking-constants';

unitTest('ui | player-types | clips | utils | tracking | base-properties', function(hooks) {
    let state;
    let content;
    let medium;
    let name;
    let lang;
    let tabSessionId;
    let userId;

    hooks.beforeEach(function() {
        tabSessionId = 'tabSessionId';
        window.sessionStorage.setItem(TAB_SESSION_ID_KEY, tabSessionId);
        content = 'content';
        medium = 'medium';
        name = 'name';
        lang = 'en';
        userId = '11231230';

        state = {
            streamMetadata: clipStreamMetadata,
            broadcasterInfo: DEFAULT_BROADCASTER_INFO,
            window: buildFakeWindow({
                location: {
                    search: `?tt_content=${content}&tt_medium=${medium}`,
                },
                Date: {
                    now() {
                        return 1000;
                    },
                },
            }),
            env: {
                playerType: PLAYER_CLIPS_EMBED,
            },
            user: {
                loggedInStatus: LOGGED_IN,
                name,
                id: userId,
            },
            lang,
        };
    });

    QUnit.module('clipsBaseProperties', function() {
        QUnit.test('should return a properly formatted data', function(assert) {
            const baseProps = clipsBaseProperties(state);

            assert.deepEqual(baseProps, {
                /* eslint-disable camelcase */
                content,
                logged_in: true,
                login: name,
                medium,
                received_language: lang,
                tab_session_id: tabSessionId,
                user_id: parseInt(userId, 10),
                vod_type: TRACKING_VOD_TYPE,
                client_time: 1,
                location: TRACKING_MEDIUM_EMBED, // TODO: update when other clips players are live
                live: false,
                time: null,
                /* eslint-enable camelcase */
            });
        });
    });

    QUnit.module('clipsClipProperties', function() {
        QUnit.test('should return a properly formatted data', function(assert) {
            const clipProps = clipsClipProperties(state);

            assert.deepEqual(clipProps, {
                /* eslint-disable camelcase */
                channel: 'nightblue3',
                channel_id: 26946000,
                game: 'League of Legends',
                live: undefined,
                partner: undefined,
                player: 'clips_embed',
                vod_id: 29332463,
                /* eslint-enable camelcase */
            });
        });
    });
});
