import { UIStateSubscriber } from 'ui/state-subscriber';
import sinon from 'sinon';
import { combineReducers, createStore } from 'redux';

QUnit.module('ui | state-subscriber', function(hooks) {
    hooks.beforeEach(function() {
        this.store = createStore(combineReducers({
            prop1(curr = 1, action) {
                return (action.type === 'test' ? action.prop1 : curr);
            },
            prop2(curr = 'one', action) {
                return (action.type === 'test' ? action.prop2 : curr);
            },
        }));
    });

    QUnit.test('subscribes to the given array of properties', function(assert) {
        const subscriber = new UIStateSubscriber();
        const spy = sinon.spy();
        subscriber.subscribe(this.store, ['prop2'], spy);

        this.store.dispatch({
            type: 'test',
            prop1: 1,
            prop2: 'two',
        });

        assert.equal(spy.callCount, 1);
        assert.deepEqual(spy.firstCall.args[0], { prop2: 'two' });
        assert.deepEqual(spy.firstCall.args[1], {
            prop1: 1,
            prop2: 'one',
        });
    });

    QUnit.test('unsubscribes to the store when destroyed', function(assert) {
        const subscriber = new UIStateSubscriber();
        const spyOne = sinon.spy();
        const spyTwo = sinon.spy();
        subscriber.subscribe(this.store, ['prop1'], spyOne);
        subscriber.subscribe(this.store, ['prop2'], spyTwo);

        this.store.dispatch({
            type: 'test',
            prop1: 1,
            prop2: 'two',
        });

        assert.equal(spyOne.callCount, 0);
        assert.equal(spyTwo.callCount, 1);

        subscriber.destroy();

        this.store.dispatch({
            type: 'test',
            prop1: 2,
            prop2: 'three',
        });

        assert.equal(spyOne.callCount, 0);
        assert.equal(spyTwo.callCount, 1);
    });
});
