import { unitTest } from 'tests/utils/module';
import { UserManager } from 'user-manager';
import { ACTION_USER_LOGGED_IN, ACTION_USER_NOT_LOGGED_IN } from 'actions/user';
import { waitFor } from 'tests/utils/waitFor';
import sinon from 'sinon';

unitTest('user-manager', function() {
    QUnit.module('on instantiation', function(hooks) {
        hooks.beforeEach(function() {
            this.store = {
                dispatch: sinon.spy(),
            };
        });

        // eslint-disable-next-line max-len
        QUnit.test('dispatches userLoggedIn action with normalized data on a successful kraken non staff user response', function(assert) {
            this.api.setLoggedIn(true);
            const userResponse = this.api.expectKrakenUserInfo({ type: 'user' });
            // eslint-disable-next-line no-unused-vars
            const userManager = new UserManager(this.store);

            return waitFor(() => this.store.dispatch.calledOnce).then(() => {
                const action = this.store.dispatch.getCall(0).args[0];
                assert.equal(action.type, ACTION_USER_LOGGED_IN);
                assert.deepEqual(action.userInfo, {
                    id: userResponse._id,
                    isStaff: userResponse.type === 'staff',
                    name: userResponse.name,
                });
            });
        });

        // eslint-disable-next-line max-len
        QUnit.test('dispatches userLoggedIn action with normalized data on a successful kraken staff user response', function(assert) {
            this.api.setLoggedIn(true);
            const staffResponse = this.api.expectKrakenUserInfo({ type: 'staff' });
            // eslint-disable-next-line no-unused-vars
            const userManager = new UserManager(this.store);

            return waitFor(() => this.store.dispatch.calledOnce).then(() => {
                const action = this.store.dispatch.getCall(0).args[0];
                assert.equal(action.type, ACTION_USER_LOGGED_IN);
                assert.deepEqual(action.userInfo, {
                    id: staffResponse._id,
                    isStaff: staffResponse.type === 'staff',
                    name: staffResponse.name,
                });
            });
        });

        QUnit.test('dispatches userNotLoggedIn action on an unsuccessful kraken user response', function(assert) {
            this.api.setLoggedIn(false);
            // eslint-disable-next-line no-unused-vars
            const userManager = new UserManager(this.store);

            return waitFor(() => this.store.dispatch.calledOnce).then(() => {
                const action = this.store.dispatch.getCall(0).args[0];
                assert.equal(action.type, ACTION_USER_NOT_LOGGED_IN);
            });
        });
    });
});
