import { createExtensionToken } from 'tests/fixtures/extensions';
import {
    EXTENSION_PERMISSION_STATE_NONE,
    EXTENSION_PERMISSION_STATE_GRANTED,
    EXTENSION_ROLE_VIEWER,
    EXTENSION_ROLE_BROADCASTER,
    parseExtensionToken,
} from 'util/extensions';

QUnit.module('util | extensions | parseExtensionToken', function() {
    QUnit.test('invalid token returns a sane default state', function(assert) {
        const parsedToken = parseExtensionToken('asdfasdf');
        assert.equal(parsedToken.permissionsState, EXTENSION_PERMISSION_STATE_NONE,
            'default token initialized to no user permission given');
        assert.equal(parsedToken.role, EXTENSION_ROLE_VIEWER, 'default token initialized to viewer role');
    });

    QUnit.test('valid token with user info granted', function(assert) {
        const token = createExtensionToken('12345', EXTENSION_ROLE_VIEWER);
        const parsedToken = parseExtensionToken(token);
        assert.equal(parsedToken.permissionsState, EXTENSION_PERMISSION_STATE_GRANTED,
            'token initialized to user permission granted');
        assert.equal(parsedToken.role, EXTENSION_ROLE_VIEWER, 'token initialized to viewer role');
    });

    QUnit.test('valid token with no user info', function(assert) {
        const token = createExtensionToken(undefined, EXTENSION_ROLE_VIEWER);
        const parsedToken = parseExtensionToken(token);
        assert.equal(parsedToken.permissionsState, EXTENSION_PERMISSION_STATE_NONE,
            'token initialized to user permission granted');
        assert.equal(parsedToken.role, EXTENSION_ROLE_VIEWER, 'token initialized to viewer role');
    });

    QUnit.test('valid token with broadcaster role', function(assert) {
        const token = createExtensionToken('12345', EXTENSION_ROLE_BROADCASTER);
        const parsedToken = parseExtensionToken(token);
        assert.equal(parsedToken.permissionsState, EXTENSION_PERMISSION_STATE_GRANTED,
            'token initialized to user permission granted');
        assert.equal(parsedToken.role, EXTENSION_ROLE_BROADCASTER, 'token initialized to broadcaster role');
    });
});
