import * as params from 'util/params';
import { unitTest } from 'tests/utils/module';

unitTest('util | params', function() {
    QUnit.module('convertUrlQueryParamTime', function() {
        QUnit.test('converts URL query param when given number in seconds', function(assert) {
            assert.equal(params.convertUrlQueryParamTime('3600'), '01h');
        });

        QUnit.test('does not convert when given value is undefined', function(assert) {
            assert.equal(params.convertUrlQueryParamTime(undefined), undefined);
        });

        QUnit.test('returns same value when value is already in the correct format', function(assert) {
            assert.equal(params.convertUrlQueryParamTime('02h30m00s'), '02h30m00s');
        });
    });
});
