import * as Timestamp from 'util/timestamp';

QUnit.module('util | timestamp', function() {
    QUnit.test('Timestamp parsing parses string into seconds', function(assert) {
        assert.equal(Timestamp.parse('1h1m1s'), 3661);
    });

    QUnit.test('Hours are optional in timestamp parsing', function(assert) {
        assert.equal(Timestamp.parse('1m1s'), 61);
    });

    QUnit.test('Minutes are optional in timestamp parsing', function(assert) {
        assert.equal(Timestamp.parse('1h1s'), 3601);
    });

    QUnit.test('Seconds are optional in timestamp parsing', function(assert) {
        assert.equal(Timestamp.parse('1h1m'), 3660);
    });

    QUnit.test('Should not convert `Infinity` to timestamp string', function(assert) {
        assert.equal(Timestamp.toString(Infinity), '00:00:00');
    });

    QUnit.test('Should not convert negative numbers to timestamp string', function(assert) {
        assert.equal(Timestamp.toString(-10), '00:00:00');
    });

    QUnit.test('Should clean strings appropriately', function(assert) {
        // Each couple here is a not cleaned vs cleaned comparison
        assert.equal(Timestamp.toString(3661, false), '01:01:01');
        assert.equal(Timestamp.toString(3661, true),   '1:01:01');

        assert.equal(Timestamp.toString(61, false), '00:01:01');
        assert.equal(Timestamp.toString(61, true),      '1:01');

        assert.equal(Timestamp.toString(3601, false), '01:00:01');
        assert.equal(Timestamp.toString(3601, true),   '1:00:01');

        assert.equal(Timestamp.toString(3660, false), '01:01:00');
        assert.equal(Timestamp.toString(3660, true),   '1:01:00');

        assert.equal(Timestamp.toString(15, false), '00:00:15');
        assert.equal(Timestamp.toString(15, true),        '15');

        assert.equal(Timestamp.toString(0, false), '00:00:00');
        assert.equal(Timestamp.toString(0, true),         '0');
    });

    QUnit.test('toURLString should format strings correctly', function(assert) {
        assert.equal(Timestamp.toURLString(3661), '01h01m01s');
        assert.equal(Timestamp.toURLString(61), '01m01s');
        assert.equal(Timestamp.toURLString(3601), '01h01s');
        assert.equal(Timestamp.toURLString(3660), '01h01m');
        assert.equal(Timestamp.toURLString(15), '15s');
        assert.equal(Timestamp.toURLString(0), '');
    });
});
