import { DEFAULT_PARAMS_BLACKLIST, sanitizeQuery } from 'util/url';

QUnit.module('util | URL', function() {
    QUnit.test(`should remove [${DEFAULT_PARAMS_BLACKLIST.join(', ')}] by default`, function(assert) {
        const actual = sanitizeQuery('http://foo.com/?oauth_token=ca5c4de5');
        assert.equal(actual, 'http://foo.com/?');
    });

    function testSanitizeQuery(url, expected, blacklist) {
        const keys = (blacklist || []).join(', ');
        const message = keys.length ?
            `should remove [${keys}] from '${url}'` :
            `should not modify the '${url}' when query params are empty`;
        QUnit.test(message, function(assert) {
            const actual = sanitizeQuery(url, blacklist);
            assert.equal(actual, expected);
        });
    }

    testSanitizeQuery('?foo&baz&debug&foo', '?baz&debug', ['foo']);
    testSanitizeQuery('?foo&baz&debug&foo', '?foo&baz&debug');
    testSanitizeQuery('http://twitch.tv', 'http://twitch.tv');
    testSanitizeQuery(
        'https://twitch.tv/?search=1&b=2&c&d&d&e&f=?????',
        'https://twitch.tv/?',
        ['search', 'b', 'c', 'd', 'e', 'f']
    );
    testSanitizeQuery(
        'https://twitch.tv/?search?debug&player=other&hello',
        'https://twitch.tv/?search%3Fdebug&hello',
        ['player']
    );
});
