import isFunction from 'lodash/isFunction';
import sinon from 'sinon';

/**
 * Invokes the event handlers attached to a subject via `addEventListener` for
 * the given event.
 *
 * @param {EventTarget} subject
 * @param {String} event
 * @param {Object=} data
 */
export function emitEvent(subject, event, data = {}) {
    const eventListenerCalls = subject.addEventListener.withArgs(event, sinon.match.any);

    for (let i = 0; i < eventListenerCalls.callCount; i++) {
        const listener = eventListenerCalls.getCall(i).args[1];

        if (isFunction(listener)) {
            // if the bound listener is a function, call it without context and
            // only with the provided data
            listener.call(null, data);
        } else if (isFunction(listener.handleEvent)) {
            // if the listener has a `handleEvent` method, call the method on
            // the listener with an Event-like object.
            listener.handleEvent({
                type: event,
                target: subject,
                currentTarget: subject,
                detail: data,
            });
        }
    }
}
