import fetchMock from 'fetch-mock';
import forEach from 'lodash/forEach';
import reduce from 'lodash/reduce';
import * as PlayerApi from 'api';
import * as API from './api';
import { localStore } from 'tests/fakes/local-store.fake';

const BASE_HOOKS = {
    beforeEach() {
        localStore.clear();

        // bind API expecation methods to this instance for convenience (allowing
        // tests to use e.g. `this.api.setLoggedIn(true)`)
        this.api = reduce(API, (api, fn, name) => {
            // eslint-disable-next-line no-param-reassign
            api[name] = fn.bind(this);
            return api;
        }, {});
        forEach(PlayerApi, apiFn => apiFn.cache && apiFn.cache.clear());
    },
    afterEach() {
        localStore.clear();
        fetchMock.restore();
    },
};

export function unitTest(filename, fn) {
    const moduleName = filename.split('/').join(' | ').replace(/\.js$/, '');
    const beforeHooks = [BASE_HOOKS.beforeEach];
    const afterHooks = [BASE_HOOKS.afterEach];

    QUnit.module(moduleName, {
        beforeEach(assert) {
            beforeHooks.forEach(hook => hook.call(this, assert));
        },
        afterEach(assert) {
            afterHooks.reverse().forEach(hook => hook.call(this, assert));
        },
    }, function() {
        fn.call(this, {
            beforeEach: hook => beforeHooks.push(hook),
            afterEach: hook => afterHooks.push(hook),
        });
    });
}
