import React from 'react';
import { shallow } from 'enzyme';
import assign from 'lodash/assign';

export function createRenderFn(Component, DEFAULT_ARGS) {
    return function(overrides = {}) {
        const args = assign({}, DEFAULT_ARGS, overrides);
        const component = <Component {...args} />;
        return shallow(component);
    };
}

export function extractIconComponent(component) {
    return component.find('Translate').getElement();
}

export function testLabel(component, label, assert) {
    const { label: resultLabel } = extractIconComponent(component).props;
    assert.equal(resultLabel, label);
}

export function testClickHandler({ component, shouldFire, shouldNotFire, assert }) {
    component.simulate('click');
    assert.equal(shouldFire.callCount, 1);
    assert.equal(shouldNotFire.callCount, 0);
}

export function testIconId(component, id, assert) {
    const { iconId } = extractIconComponent(component).props;
    assert.equal(iconId, id);
}

export function testButtonHasClass(component, className, assert) {
    assert.ok(component.hasClass(className), `has ${className} class`);
}

export function testButtonNotHasClass(component, className, assert) {
    assert.notOk(component.hasClass(className), `does not have ${className} class`);
}

export function testButtonDisabled(component, assert) {
    assert.ok(component.props().disabled, 'button is disabled');
}

export function testButtonNotDisabled(component, assert) {
    assert.notOk(component.props().disabled, 'button is not disabled');
}
