const DEFAULT_TIMEOUT = 2500;

/**
 * Repeatedly executes the given testFn until it returns true, at which point
 * it resolves the returned promise. Will reject the promise if `timeout` ms
 * pass before the testFn returns true.
 *
 * @param {Function} testFn
 * @param {Number} timeout
 * @return {Promise}
 */
export function waitFor(testFn, timeout = DEFAULT_TIMEOUT) {
    return new Promise(function(resolve, reject) {
        const timeoutId = setTimeout(function() {
            reject(new Error('waitFor timeout'));
            clearTimeout(timeoutId);
            clearInterval(intervalId);
        }, timeout);

        const intervalId = setInterval(function() {
            const result = testFn();
            if (result) {
                resolve(result);
                clearTimeout(timeoutId);
                clearInterval(intervalId);
            }
        }, 10);
    });
}
