import jenkins.model.Jenkins
import javaposse.jobdsl.dsl.helpers.*
import javaposse.jobdsl.dsl.helpers.step.*

proxy = Jenkins.getInstance().proxy

StepContext.metaClass.saveDeployArtifact = { String repo, String directory ->
	shell """cd ${directory}
courierd -create-manifest \$GIT_COMMIT.manifest -private-key /root/.ssh/courierd
tar -czf /tmp/\$GIT_COMMIT.tgz .
AWS_ACCESS_KEY_ID=\$DEPLOY_ARTIFACT_AWS_ACCESS_KEY AWS_SECRET_ACCESS_KEY=\$DEPLOY_ARTIFACT_AWS_SECRET_KEY aws s3 cp /tmp/\$GIT_COMMIT.tgz s3://devtools-deploy-artifacts/${repo}/\$GIT_COMMIT.tgz
rm /tmp/\$GIT_COMMIT.tgz
	"""
}

StepContext.metaClass.saveDirtyDeployArtifact = { String repo, String directory ->
	shell """cd ${directory}
courierd -create-manifest \$GIT_COMMIT.manifest -private-key /root/.ssh/courierd
tar -czf /tmp/\$GIT_COMMIT.tgz .
AWS_ACCESS_KEY_ID=\$DIRTY_DEPLOY_ARTIFACT_AWS_ACCESS_KEY AWS_SECRET_ACCESS_KEY=\$DIRTY_DEPLOY_ARTIFACT_AWS_SECRET_KEY aws s3 cp /tmp/\$GIT_COMMIT.tgz s3://twitch-build-artifacts/${repo}/\$GIT_COMMIT.tgz
rm /tmp/\$GIT_COMMIT.tgz
	"""
}

StepContext.metaClass.downloadDeployArtifact = { String repo ->
	shell """
AWS_ACCESS_KEY_ID=\$DEPLOY_ARTIFACT_AWS_ACCESS_KEY AWS_SECRET_ACCESS_KEY=\$DEPLOY_ARTIFACT_AWS_SECRET_KEY aws s3 cp s3://devtools-deploy-artifacts/${repo}/\$GIT_COMMIT.tgz \$GIT_COMMIT.tgz
tar -xzf \$GIT_COMMIT.tgz
rm \$GIT_COMMIT.tgz
"""
}

StepContext.metaClass.saveTerraformBackup = { String repo, String filename ->
	shell """
AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY aws s3 cp ${filename} s3://jenkins-terraform-backup/${repo}/\$GIT_COMMIT-\$(date +%Y%m%dT%H%M%S).tfstate
"""
}

StepContext.metaClass.uploadBeanstalkApp = { String app, String filename ->
	shell """
export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
aws s3 cp ${filename} s3://elastic-beanstalk-docker/${app}/\$GIT_COMMIT.zip
aws elasticbeanstalk create-application-version --no-auto-create-application --application-name ${app} --version-label \$GIT_COMMIT --source-bundle S3Bucket=elastic-beanstalk-docker,S3Key=${app}/\$GIT_COMMIT.zip
"""
}

/**
 * uploadDeb(path)
 * uploadDeb(path, version)
 * uploadDeb(path, [version1, version2])
 *
 * The first form uploads the deb to the default flavours of ubuntu
 * The second form permits you to specify a specific version of ubuntu
 * The third form permits you to specify multiple specific versions of ubuntu
 *
 * The default versions are: precise, lucid, trusty
 */
StepContext.metaClass.uploadDeb = { String debPath, releases = ['precise', 'lucid', 'trusty'] ->
	if ( releases instanceof String ) {
		releases = [releases]
	}

	releases.each { rel ->
	  debNameStub = debPath.split("/").last().replaceFirst(".deb", "")
	  cmd = 'VERSION=`dpkg-deb -I ' + debPath + ' | grep "^ Version: " | cut -d" " -f3`; ' +
	    'ARCH=`dpkg-deb -I ' + debPath + ' | grep "^ Architecture: " | cut -d" " -f3`; ' +
	    'curl -svif -XPOST http://aptly-mirror-6db0a8.sfo01.justin.tv:5000/repo/' + rel + '/' + debNameStub + '_${VERSION}_${ARCH}.deb ' +
	    '--header "Content-Type: application/octet-stream" ' +
	    '--data-binary @"' + debPath + '"'
	  shell cmd
	}
}

/**
 * uploadDirtyDeb(path)
 * uploadDirtyDeb(path, version)
 * uploadDirtyDeb(path, [version1, version2])
 *
 * The first form uploads the deb to the default flavours of ubuntu
 * The second form permits you to specify a specific version of ubuntu
 * The third form permits you to specify multiple specific versions of ubuntu
 *
 * The default versions are: precise, lucid
 */
StepContext.metaClass.uploadDirtyDeb = { String debPath, releases = ['precise', 'lucid'] ->
	if ( releases instanceof String ) {
		releases = [releases]
	}

	releases.each { rel ->
	  debNameStub = debPath.split("/").last().replaceFirst(".deb", "")
	  cmd = 'VERSION=`dpkg-deb -I ' + debPath + ' | grep "^ Version: " | cut -d" " -f3`; ' +
	    'ARCH=`dpkg-deb -I ' + debPath + ' | grep "^ Architecture: " | cut -d" " -f3`; ' +
	    'curl -svif -XPOST  http://media66.justin.tv:5000/repo/' + rel + '/' + debNameStub + '_${VERSION}_${ARCH}.deb ' +
	    '--header "Content-Type: application/octet-stream" ' +
	    '--data-binary @"' + debPath + '"'
	  shell cmd
	}
}

job {
	name 'TEMPLATE-base'
	concurrentBuild true
	quietPeriod 45
	triggers {
		githubPush()
	}
	configure { project ->
		project / builders / 'com.cloudbees.jenkins.GitHubSetCommitStatusBuilder'
	}
	publishers {
		githubCommitNotifier()
	}
	wrappers {
		sshAgent 'git-aws-read-key'
	}
}
