import jenkins.model.Jenkins

StepContext.metaClass.runCodeDeploy = { void ->
	shell """
  : ${APPNAME:=$OWNER-$REPO}
  : ${DEPLOYMENT_GROUP:=$OWNER-$REPO-$ENVIRONMENT}
  : ${S3LOCATION:=devtools-deploy-artifacts/$OWNER/$REPO}
  : ${BUNDLETYPE:=tar}
  : ${DEPLOYMENT_CONFIG:=CodeDeployDefault.AllAtOnce}

  # post to mekansm
  MEK_RESP=curl \
   -H "Content-Type: application/json" \
   -X POST \
   -d '{"owner":"'$OWNER'", \
   '{"repo":"'$REPO'", \
   '{"triggered_by":"'$TRIGGERED_BY'", \
   '{"appname":"'$APPNAME'", \
   '{"deployment_group":"'$DEPLOYMENT_GROUP'", \
   '{"s3location":"'$S3LOCATION'", \
   '{"bundletype":"'$BUNDLETYPE'", \
   '{"sha":"'$GIT_COMMIT'", \
   '{"deployment_config":"'$DEPLOYMENT_CONFIG'", \
   '{"nodes_dc":"'$NODES_DC'", \
   "password": ""}' \
   $MEKANSM_URL

  if [[ $MEK_RESP != *"200 OK"* ]]; then
    echo "Error posting deployment to mekansm"
    exit 1
  fi

  #TODO: update with finalized response data
  DEPLOYMENT_ID=`expr "$MEK_RESP" : ".*deployment_id[\"|\']\s*:\s*\(.*[^}]\)"|xargs`

  # Poll mekansm for deployment status
  while true; do
    MEK_RESP=curl \
    -X GET \
    $MEKANSM_URL$DEPLOYMENT_ID

    if [[ $MEK_RESP != *"200 OK"* ]]; then
      echo "Error getting deployment status from mekansm"
      exit 1
    fi

    DEP_STATUS=`expr "$MEK_RESP" : ".*status[\"|\']\s*:\s*\(.*[^}]\)"|xargs` 
    if [[ $DEP_STATUS == *"Stopped"* ]]; then 
      echo "Deployment was stopped"
      exit 1
    fi
    if [[ $DEP_STATUS == *"Failed"* ]]; then 
      echo "Deployment failed"
      exit 1
    fi
    if [[ $DEP_STATUS == *"Succeeded"* ]]; then 
      echo "Deployment succeeded"
      exit 0
    fi
    sleep 2
  done
	"""
}

job {
	name 'TEMPLATE-codedeploy'
	quietPeriod 0
	parameters {
		stringParam 'REPO'
		stringParam 'OWNER'
		stringParam 'ENVIRONMENT'
		stringParam 'NODES_DC'
		stringParam 'GIT_COMMIT'
		stringParam 'TRIGGERED_BY'
		stringParam('MEKANSM_URL', 'http://mekansm.justin.tv/deployments/', 'endpoint to post/get deployments. Use trailing slash')
    //The parameters below can be null
		stringParam 'APPNAME'
		stringParam 'DEPLOYMENT_GROUP'
		stringParam 'S3LOCATION'
		stringParam 'BUNDLETYPE'
		stringParam 'DEPLOYMENT_CONFIG'
	}
	wrappers {
    //TODO: is any sshAgent required?
		preBuildCleanup()
		timestamps()
	}
}
