import jenkins.model.Jenkins

job {
	name 'TEMPLATE-deploy'
	quietPeriod 0
	concurrentBuild true
	parameters {
		stringParam 'GIT_COMMIT'
		stringParam 'HOSTS'
		stringParam 'ENVIRONMENT'
	}
	wrappers {
		sshAgent 'jtv-deploy-user'
		preBuildCleanup()
		timestamps()
		environmentVariables {
			envs([
				'HTTP_PROXY': 'http://proxy.internal.justin.tv:9797/',
				'HTTPS_PROXY': 'http://proxy.internal.justin.tv:9797/',
				'NO_PROXY': 'localhost,127.0.0.1,127.0.1.1,127.0.0.0/8,199.9.248.0/21,192.16.64.0/21,10.0.0.0/8,52.223.240.0/20,.internal.justin.tv,.internal.twitch.tv,.justin.tv,.twitch.tv,.jtvnw.net',
			])
		}
	}
}

job {
	name 'TEMPLATE-deploy-aws'
	quietPeriod 0
	concurrentBuild true
	parameters {
		stringParam 'GIT_COMMIT'
		stringParam 'HOSTS'
		stringParam 'ENVIRONMENT'
	}
	wrappers {
		sshAgent 'jtv-deploy-user'
		preBuildCleanup()
		timestamps()
	}
}
