#!/usr/bin/env python

import requests, os, errno, sys, codecs, re

# Find all "jenkins.groovy" files in all Twitch repos.  Download them,
# and store them in the right place for Jenkins to use.


oauth_token = os.environ['GITHUB_AUTH']

def mkdir_p(path):
    try:
        os.makedirs(path)
    except OSError as exc:
        if exc.errno == errno.EEXIST and os.path.isdir(path):
            pass
        else: raise
        
def main():
    print 'Getting jenkins jobs from other repos...'

    current_page, total_page = 1, 1

    req = requests.get(
            'https://git-aws.internal.justin.tv/api/v3/search/code?q=jenkins.groovy+in:path&per_page=100',
            auth=(oauth_token, ''))

    get_page(req.json())

    while True:
        link = req.headers['link']
        if link == '':
            return

        next = get_next(link)

        if next == "":
            return

        print "Got another page"
        req = requests.get(
                next,
                auth=(oauth_token, ''))

        get_page(req.json())

def get_next(link):
    links = link.split(",")

    for link in links:
        search = re.search(r'rel="(.*)"', link)
        rel = search.groups()[0]
        if rel != "next":
            continue

        search = re.search(r'<(.*)>', link)
        if search == None:
            print >>sys.stderr, "Can't find the shit"
            exit (-1)

        return search.groups()[0]

    return ""
    



def get_page(results):
    if len(results['items']) == 0:
        print >> sys.stderr, "Found no items"
        exit (-1)

    for result in results['items']:
        #import json
        #print json.dumps(result, sort_keys=True,
        #         indent=4, separators=(',', ': '))

        # The new search query will jenkins.groovy that is not in the root
        # directory. This has an issue here jenkins.groovy in godeps will
        # overwrite the actual jenkins.groovy.
        if result['path'] != '/jenkins.groovy' and result['path'] != '.ttv.d/jenkins.groovy':
            continue

        repo = result['repository']['name']
        org = result['repository']['owner']['login']

        # curl https://git-aws.internal.justin.tv/raw/release/skadi/master/jenkins.groovy
        url = "https://git-aws.internal.justin.tv/raw/%s/%s/master/%s" % (org, repo, result['path'].lstrip('/'))
        print "Downloading %s" % (url)

        groovy = requests.get(url, auth=(oauth_token, '')).text
        print '%s/%s...' % (org, repo)
        mkdir_p(org)
        with codecs.open('%s/%s.groovy' % (org, repo), 'w', encoding="utf-8") as f:
            f.write(groovy)

if __name__ == "__main__":
    main()
