def projects = [
  ['disk-alert', 'd8a/pkg-diskspacealert'],
  ['exhibitor', 'd8a/pkg-exhibitor'],
  ['goose', 'd8a/pkg-goose'],
  ['kafka-syslog', 'd8a/pkg-kafka-syslog'],
  ['pg-healthcheck', 'd8a/pg-healthcheck'],
  ['pg-plan-filter', 'd8a/pg_plan_filter'],
  ['pg-stats', 'd8a/pg-stats'],
  ['pgbadger', 'd8a/pkg-pgbadger'],
  ['pgbouncer', 'd8a/pgbouncer-jtv'],
  ['pgbouncer-stats', 'd8a/pgbouncer-stats'],
  ['zk-stats','d8a/zk-stats'],
  ['zk-alerts','d8a/zk-alerts'],
]

projects.each { spec ->
  def project = spec[0]
  def repo    = spec[1]

  job {
    name "d8a-${project}"
    using 'TEMPLATE-autobuild'
    scm {
      git {
        remote {
          github repo, 'ssh', 'git-aws.internal.justin.tv'
          credentials 'git-aws-read-key'
        }
        clean true
      }
    }
    steps {
      shell 'manta -proxy'
      saveDeployArtifact "d8a/${project}", '.manta'
    }
  }

  job {
    name "d8a-${project}-aptly"
    parameters {
      stringParam 'GIT_COMMIT'
    }
    steps {
      downloadDeployArtifact "d8a/${project}"
      uploadDeb "${project}.deb", 'precise'
    }
    wrappers {
      preBuildCleanup()
      timestamps()
    }
  }

}
