job {
	name 'release-courier'
	using 'TEMPLATE-autobuild'
	scm {
		git {
			remote {
				github 'release/courier', 'ssh', 'git-aws.internal.justin.tv'
				credentials 'git-aws-read-key'
			}
		}
	}
	steps {
		shell 'rm -rf .manta/'
		shell 'manta -v'
		saveDeployArtifact 'release/courier', '.manta'
	}
}

job {
	name 'release-courier-aptly'
	parameters {
		stringParam 'GIT_COMMIT'
	}
	steps {
		downloadDeployArtifact 'release/courier'
		uploadDeb "courier.deb"
		uploadDirtyDeb "courier.deb"
	}
	wrappers {
		preBuildCleanup()
		timestamps()
	}
}

job {
	name 'release-courier-integration-tar'
	using 'TEMPLATE-autobuild'
	scm {
		git {
			remote {
				github 'release/courier-integration-tar', 'ssh', 'git-aws.internal.justin.tv'
				credentials 'git-aws-read-key'
			}
		}
	}
	steps {
		saveDeployArtifact 'release/courier-integration-tar', '.'
	}	
}
