def packer = [
  version: "0.7.5",
  sha: "8fab291c8cc988bd0004195677924ab6846aee5800b6c8696d71d33456701ef6"
]

def buildProps = [
  vpc: "vpc-0713b162",
  subnet: "subnet-ef4ab1b6",
  securityGroup: "sg-d9bc9abc",
]

def legacyBaseAmi = "ami-e1ba97d1"
def baseAmi = "ami-ef1f098e"

def mantaFileUrl(jsonName) {
  'https://\$JOB_DSL_SEED@git-aws.internal.justin.tv/raw/release/jenkins-jobs/master/jobs/science/resources/' + jsonName
}

job {
  name 'science-baseami'
  using 'TEMPLATE-autobuild'
  wrappers {
    credentialsBinding {
      string 'AWS_ACCESS_KEY', 'science-eng-aws-access-key'
      string 'AWS_SECRET_KEY', 'science-eng-aws-secret-key'
      string 'JOB_DSL_SEED',   'job-dsl-seed'
    }
  }
  scm {
    git {
      remote {
        github 'stats/baseami', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell 'curl -LO ' + mantaFileUrl('baseami.json')
    shell 'manta -f baseami.json -proxy ' +
          '-e PACKER_VERSION=' + packer.version + ' ' +
          '-e PACKER_SHA=' + packer.sha + ' ' +
          '-e BRANCH_NAME=${GIT_BRANCH#*/} ' +
          '-e AWS_ACCESS_KEY ' +
          '-e AWS_SECRET_KEY ' +
          '-e VPC=' + buildProps.vpc + ' ' +
          '-e SUBNET=' + buildProps.subnet + ' ' +
          '-e SECURITY_GROUP=' + buildProps.securityGroup + ' '
  }
}

// format: projectName, repohost, repo, project_type{go|java}, baseami
def projects = [
                ['almanac', 'git-aws.internal.justin.tv', 'stats/almanac', 'go', legacyBaseAmi],
                ['asgard', 'git-aws.internal.justin.tv', 'stats/asgard', 'java', legacyBaseAmi],
                ['blueprint', 'github.com', 'twitchscience/blueprint', 'go', baseAmi],
//                ['consumetrics', 'git-aws.internal.justin.tv', 'gareth/kafkaThroughput', 'go', legacyBaseAmi],
                ['jobs', 'git-aws.internal.justin.tv', 'stats/jobs', 'go', legacyBaseAmi],
                ['kafka', 'git-aws.internal.justin.tv', 'stats/kafka', 'java', baseAmi],
                ['mcfly', 'git-aws.internal.justin.tv', 'stats/mcfly', 'go', baseAmi],
                ['rs_ingester', 'github.com', 'twitchscience/rs_ingester', 'go', baseAmi],
                ['s3proxy', 'git-aws.internal.justin.tv', 'stats/s3proxy', 'go', baseAmi],
                ['scoop', 'git-aws.internal.justin.tv', 'stats/scoop', 'go', baseAmi],
                ['spade', 'github.com', 'twitchscience/spade', 'go', baseAmi],
                ['spade_edge', 'github.com', 'twitchscience/spade_edge', 'go', baseAmi],
                ['spade_edge_monitor', 'git-aws.internal.justin.tv', 'stats/spade-edge-monitor', 'java', baseAmi],
                ['steamscraper', 'git-aws.internal.justin.tv', 'stats/steamscraper', 'go', baseAmi],
                ['zookeeper', 'git-aws.internal.justin.tv', 'stats/zookeeper', 'java', baseAmi],
//                ['kafka_manager', 'git-aws.internal.justin.tv', 'stats/kafka_manager', 'java', legacyBaseAmi]
               ]

projects.each { spec ->
  def project     = spec[0]
  def repoHost    = spec[1]
  def repo        = spec[2]
  def projectType = spec[3]
  def baseami     = spec[4]

  switch(repoHost) {
    case 'github.com':
      repoProto = 'https'
      break
    default:
      repoProto = 'ssh'
  }

  job {
    name "science-${project}"
    using 'TEMPLATE-autobuild'
    wrappers {
      credentialsBinding {
        string 'AWS_ACCESS_KEY', 'science-eng-aws-access-key'
        string 'AWS_SECRET_KEY', 'science-eng-aws-secret-key'
        string 'JOB_DSL_SEED',   'job-dsl-seed'
      }
      colorizeOutput()
    }
    scm {
      git {
        remote {
          github repo, repoProto, repoHost
          if ( repoHost == "git-aws.internal.justin.tv" ) {
            credentials 'git-aws-read-key'
          }
        }
        clean true
      }
    }
    triggers {
        if (repoHost == 'github.com') {
            scm 'H/3 * * * *'
        }
    }
    steps {
      shell 'curl -LO ' + mantaFileUrl(projectType + '_project.json')
      shell 'curl -LO ' + mantaFileUrl(project + '.json')
      shell 'manta -f '+ projectType + '_project.json -proxy '    +
            '-f ' + project + '.json '                            +
            '-e PACKER_VERSION=' + packer.version + ' '           +
            '-e PACKER_SHA=' + packer.sha + ' '                   +
            '-e AWS_ACCESS_KEY '                                  +
            '-e AWS_SECRET_KEY '                                  +
            '-e PROJECT=' + project + ' '                         +
            '-e BRANCH_NAME=${GIT_BRANCH#*/} '                    +
            '-e SOURCE_AMI=' + baseami + ' '                      +
            '-e VPC=' + buildProps.vpc + ' '                      +
            '-e SUBNET=' + buildProps.subnet + ' '                +
            '-e SECURITY_GROUP=' + buildProps.securityGroup + ' '

    }
  }
}
