def migrations = [
 ['justintv_dev', 'web/migrations-justintv_dev'],
 ['justintv_prod', 'web/migrations-justintv_prod'],
]

migrations.each { migration ->
  def schema = migration[0]
  def repo   = migration[1]

  job {
    name "migrations-${schema}"
    using 'TEMPLATE-autobuild'
    scm {
      git {
        remote {
          github repo, 'ssh', 'git-aws.internal.justin.tv'
          credentials 'git-aws-read-key'
        }
      }
    }
    steps {
      saveDeployArtifact repo, '.'
    }
  }

  job {
    name "migrations-${schema}-deploy"
    using 'TEMPLATE-deploy'
    steps {
      shell "courier deploy --skip-restart --repo ${repo} --dir /opt/twitch/migrations/${schema}"
    }
  }
}
