/* global module, __dirname */
/* eslint-disable camelcase */
var webpack = require('webpack');
var path = require('path');
var glob = require('glob');
var ExtractTextPlugin = require('extract-text-webpack-plugin');

module.exports = function (grunt) {
    grunt.registerTask('test:ci:remote', ['clean', 'webpack:tests', 'exec:testem_ci_remote']);
    grunt.registerTask('test:ci:local', ['clean', 'webpack:tests', 'exec:testem_ci_local']);
    grunt.registerTask('test:server', ['clean', 'webpack:tests', 'exec:testem_server']);
    grunt.registerTask('test:watch', ['watch']);

    grunt.loadNpmTasks('grunt-webpack');
    grunt.loadNpmTasks('grunt-exec');
    grunt.loadNpmTasks('grunt-contrib-watch');
    grunt.loadNpmTasks('grunt-contrib-clean');

    grunt.initConfig({
        webpack: {
            tests: {
                devtool: 'source-map',
                entry: glob.sync('./tests/src/**/*.test.js').reduce(function (entry, dir) {
                    entry[path.relative('./tests/src', dir)] = dir;
                    return entry;
                }, {}),
                output: {
                    path: path.resolve('tests/build'),
                    filename: '[name]',
                    sourceMapFilename: '[file].map',
                },
                module: {
                    loaders: [
                        {
                            test: /\.js$/,
                            loader: 'babel-loader',
                            query: {
                                presets: ['es2015'],
                            },
                            include: [
                                path.resolve('src', 'js'),
                                path.resolve('tests', 'src', 'js'),
                                path.resolve(__dirname, 'node_modules/pubsub-js-client'),
                            ],
                        },
                        {
                            test: /\.sass$/,
                            loader: ExtractTextPlugin.extract(
                                'style-loader',
                                'css!sass?indentedSyntax=true'
                            ),
                        },
                    ],
                },
                resolve: {
                    root: ['src/js', 'node_modules'],
                    modulesDirectories: ['src/js', 'node_modules'],
                    alias: {
                        'event-emitter': 'wolfy87-eventemitter',
                    },
                },
                plugins: [
                    new webpack.ProvidePlugin({
                        $: 'jquery',
                        _: 'underscore',
                    }),
                    new ExtractTextPlugin('css/[name].[contenthash].css'),
                ],
            },
        },
        clean: {
            build: ['tests/build'],
        },
        exec: {
            testem_ci_remote: {
                command() {
                    return './node_modules/.bin/testem ci --launch PhantomJS';
                },
            },
            testem_ci_local: {
                command() {
                    return './node_modules/.bin/testem ci --launch Chrome,PhantomJS';
                },
            },
            testem_server: {
                command() {
                    return './node_modules/.bin/testem server';
                },
            },
        },
        watch: {
            scripts: {
                files: [
                    path.join('src', 'js', '**', '*.js'),
                    path.join('src', '**', '*.html'),
                    path.join('tests', 'src', '**', '*.js'),
                ],
                tasks: ['webpack:tests'],
            },
        },
    });
};
