player-ui
=========

Universal Player UI for Web Playback.

Development Steps
=================

If you do not already have a hosts entry for your local machine, run the
following command:

```shell
sudo echo "127.0.0.1  localhost.twitch.tv" >> /etc/hosts
```

Before you start development on this repo, you should run the following command to set up githooks:
```shell
scripts/setup_hooks
```

To start the development server (with automatic browser sync), run:

```shell
npm start
```

This will automatically build the project as well as host it locally, pointed at
production data. You will need to have run the previous command appending a line
to your `/etc/hosts` file for this to work correctly; many of the API calls in
the critical path to loading video require CORS access, which is only granted to
requests matching the wildcard domain `*.twitch.tv`.

You can also run a local web server (such as NGINX or Apache) pointed at
`$(cwd)/build`; this can be helpful when testing under HTTPS, as the current
system explicitly does not load the page under HTTPS. Note that this should be
changed when the site switches to HTTPS Everywhere *and* video is served over
HTTPS.

To load specific channels, change the URL to `localhost.twitch.tv:8000?channel=<YOUR_CHANNEL>`,
and to load VOD content, use `localhost.twitch.tv:8000?video=v<VIDEO_ID>`.

[Here is the full list of available parameters](https://git-aws.internal.justin.tv/video/player-ui/wiki/Player-Integration#options).


Internationalization
====================
player-ui uses Smartling to localize all its strings. The following grunt tasks are available regarding internationalization:
* ```grunt smartling_upload``` - This command will upload the `localization/strings.pot` file to Smartling. Any new strings to be translated should be included in the file in Gettext format before uploading.
* ```grunt smartling_get``` - This command will fetch the published translations from Smartling for all the locales we support in .po files. This should always be followed by `grunt po-to-json`.
* ```grunt po-to-json``` - This command converts the .po localization files to .json for parsing by our i18n module.
* ```grunt i18n``` - This command does the previous three commands in sequence, for ease of use.

To set a language, use the `setLanguage` method in player.js.
To localize a string, use the i18n module in the State-Tracker, which has a method `translate`, which takes the English string (the `msgid` in the .pot file) to translate, as well as additional options. The additional options are listed here: http://i18next.com/docs/options/#t-options
