job {
	name "video-player-ui-test"
	scm {
		git {
			remote {
				github 'video/player-ui', 'ssh', 'git-aws.internal.justin.tv'
				credentials 'git-aws-read-key'
			}
			clean true
		}
	}

	steps {
		shell 'rm -rf .manta'
		shell 'manta -v -proxy'
		shell """
		Xvfb :1 -screen 0 1024x768x16 &> xvfb.log  &
		export DISPLAY=:1.0
		npm test
		"""

		saveDeployArtifact 'video/player-ui', '.manta'
	}
  throttleConcurrentBuilds {
    maxTotal 4
    maxPerNode 1
  }

}

job {
	name "video-player-ui-test-dep"
	using "TEMPLATE-deploy"

	parameters {
		stringParam("BRANCH", "", "branch name being deployed")
	}

	wrappers {
		credentialsBinding {
			file('AWS_CONFIG_FILE', 'aws_config')
			string 'PLAYER_AWS_ACCESS_KEY', 'video-player-assets-access-key'
			string 'PLAYER_AWS_SECRET_KEY', 'video-player-assets-secret-key'
		}
	}

	steps {
		downloadDeployArtifact 'video/player-ui'
		shell """
export AWS_ACCESS_KEY_ID=\$PLAYER_AWS_ACCESS_KEY
export AWS_SECRET_ACCESS_KEY=\$PLAYER_AWS_SECRET_KEY
deploy/upload.sh -b "\$BRANCH" -d dist -e "\$ENVIRONMENT"
"""
	}
}
