'use strict';

exports.__esModule = true;

var _postcss = require('postcss');

var _postcss2 = _interopRequireDefault(_postcss);

var _postcssValueParser = require('postcss-value-parser');

var _postcssValueParser2 = _interopRequireDefault(_postcssValueParser);

var _colormin = require('colormin');

var _colormin2 = _interopRequireDefault(_colormin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function reduceWhitespaces(decl) {
    decl.value = (0, _postcssValueParser2.default)(decl.value).walk(function (node) {
        if (node.type === 'function' || node.type === 'div') {
            node.before = node.after = '';
        }
    }).toString();
}

function transform(decl) {
    if (decl.prop === '-webkit-tap-highlight-color') {
        if (decl.value === 'inherit' || decl.value === 'transparent') {
            return;
        }
        return reduceWhitespaces(decl);
    }
    if (/^(font|filter)/.test(decl.prop)) {
        return;
    }
    decl.value = (0, _postcssValueParser2.default)(decl.value).walk(function (node) {
        if (node.type === 'function') {
            if (/^(rgb|hsl)a?$/.test(node.value)) {
                node.value = (0, _colormin2.default)((0, _postcssValueParser.stringify)(node));
                node.type = 'word';
            } else if (node.value === 'calc') {
                return false;
            }
        } else {
            node.value = (0, _colormin2.default)(node.value);
        }
    }).toString();
}

exports.default = _postcss2.default.plugin('postcss-colormin', function () {
    return function (css) {
        return css.walkDecls(transform);
    };
});
module.exports = exports['default'];