'use strict';

exports.__esModule = true;

var _declaration = require('./declaration');

var _declaration2 = _interopRequireDefault(_declaration);

var _processor = require('./processor');

var _processor2 = _interopRequireDefault(_processor);

var _stringify = require('./stringify');

var _stringify2 = _interopRequireDefault(_stringify);

var _comment = require('./comment');

var _comment2 = _interopRequireDefault(_comment);

var _atRule = require('./at-rule');

var _atRule2 = _interopRequireDefault(_atRule);

var _vendor = require('./vendor');

var _vendor2 = _interopRequireDefault(_vendor);

var _parse = require('./parse');

var _parse2 = _interopRequireDefault(_parse);

var _list = require('./list');

var _list2 = _interopRequireDefault(_list);

var _rule = require('./rule');

var _rule2 = _interopRequireDefault(_rule);

var _root = require('./root');

var _root2 = _interopRequireDefault(_root);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var postcss = function postcss() {
    for (var _len = arguments.length, plugins = Array(_len), _key = 0; _key < _len; _key++) {
        plugins[_key] = arguments[_key];
    }

    if (plugins.length === 1 && Array.isArray(plugins[0])) {
        plugins = plugins[0];
    }
    return new _processor2.default(plugins);
};

postcss.plugin = function (name, initializer) {
    var creator = function creator() {
        var transformer = initializer.apply(undefined, arguments);
        transformer.postcssPlugin = name;
        transformer.postcssVersion = new _processor2.default().version;
        return transformer;
    };

    creator.postcss = creator();
    creator.process = function (css, opts) {
        return postcss([creator(opts)]).process(css, opts);
    };
    return creator;
};

postcss.stringify = _stringify2.default;
postcss.vendor = _vendor2.default;
postcss.parse = _parse2.default;
postcss.list = _list2.default;

postcss.comment = function (defaults) {
    return new _comment2.default(defaults);
};
postcss.atRule = function (defaults) {
    return new _atRule2.default(defaults);
};
postcss.decl = function (defaults) {
    return new _declaration2.default(defaults);
};
postcss.rule = function (defaults) {
    return new _rule2.default(defaults);
};
postcss.root = function (defaults) {
    return new _root2.default(defaults);
};

exports.default = postcss;
module.exports = exports['default'];