var Base64 = require('../../bower_components/crypto-js/enc-base64');
var Utf8   = require('../../bower_components/crypto-js/enc-utf8');
var ajax   = require('../ajax');

/**
 * Spade beacon URL
 * @var {String}
 */
exports.SPADE_URL = '//spade.twitch.tv/';

/**
 * Send an event to the Spade service
 *
 * @param {String} event
 * @param {Object} properties
 * @param {Function} callback
 */
exports.sendEvent = function(event, properties, callback) {
	var data = {
		event:      event,
		properties: properties
	};
	var payload = Base64.stringify(Utf8.parse(JSON.stringify(data)));

	ajax.fetch(
		exports.SPADE_URL + '?data=' + encodeURIComponent(payload),
		{},
		callback
	);
}
