/* globals $ */

const statsBaseDarklaunch = "https://client-event-reporter-darklaunch.twitch.tv";
const statsBaseProduction = "https://client-event-reporter.twitch.tv";

const statsPrefixDarklaunch = "pubsub-js-client.darklaunch.";
const statsPrefixProduction = "pubsub-js-client.production.";

const ajaxTimeout = 30 * 1000; // 30 seconds

class Stats {
  constructor(opts) {
    this._env = opts.env;
    switch (this._env) {
    case "production":
      this._addr = statsBaseProduction;
      this._prefix = statsPrefixProduction;
      break;
    case "darklaunch":
      this._addr = statsBaseDarklaunch;
      this._prefix = statsPrefixDarklaunch;
      break;
    default:
      this._addr = statsBaseDarklaunch;
      this._prefix = statsPrefixDarklaunch;
    }
  }

  setPrefix (prefix) {
    this._prefix = prefix;
  }

  sendStatCounter (key, rate) {
    if (Math.random() < rate) {
      $.ajax({
        type: "POST",
        url: this._addr + "/v1/counter",
        timeout: ajaxTimeout,
        data: {
          "key": this._prefix + key,
          "count":"1",
          "sample_rate": rate
        }
      });
    }
  }

  sendStatTimer (key, ms, rate) {
    if (Math.random() < rate) {
      $.ajax({
        type: "POST",
        url: this._addr + "/v1/timer",
        timeout: ajaxTimeout,
        data: {
          "key": this._prefix + key,
          "milliseconds": ms,
          "sample_rate": rate
        }
      });
    }
  }

  sendStatLogger (line) {
    $.ajax({
      type: "POST",
      url: this._addr + "/v1/logger",
      timeout: ajaxTimeout,
      data: {
        "log_line": line
      }
    });
  }
}

export default Stats;
