/**
 * Countess Client
 * @class
 * @constructor
 *
 * @param {Object} opts
 *        `host`: Countess API host
 */
export function CountessTracker(opts) {
    this._host = opts.host;
}

/**
 * Send a tracking event to Countess, which doesn't implement CORS and requires
 * a slightly different tracking method.
 * @private
 *
 * @param {String} url
 */
CountessTracker.prototype._trackEvent = function(url) {
    var img = new Image();
    img.src = url;
};

/**
 * Send a VOD view count event to Countess
 *
 * @param {Object} videoInfo The API response for video metadata
 */
CountessTracker.prototype.trackVODView = function(videoInfo) {
    this._trackEvent(videoInfo.increment_view_count_url);
};

/**
 * Send a channel view count event to Countess. This should happen regardless
 * of whether the channel is online or offline.
 *
 * @param {String} channelInfo The API response for channel metadata
 */
CountessTracker.prototype.trackChannelView = function(channelInfo) {
    var payload = {
        type: 'channel',
        id: channelInfo._id,
    };
    var queryParams = {
        u: JSON.stringify(payload),
    };
    var url = `${this._host}/ping.gif?${$.param(queryParams)}`;

    this._trackEvent(url);
};
