import * as Settings from '../settings';

/**
 * Mixpanel Client
 * @class
 * @constructor
 *
 * @param {Object} opts
 *        `host`: Mixpanel API host
 *        `token`: Mixpanel API token
 */
export function MixpanelClient(opts) {
    this._host = opts.host;
    this._token = opts.token;
}

/**
 * Send an event to Mixpanel.
 *
 * @param {String} eventName
 * @param {Object} properties
 */
MixpanelClient.prototype.trackEvent = function(eventName, properties) {
    if (_.contains(Settings.mixpanelIgnore, eventName)) {
        return;
    }

    // Token and time should be added to every request.
    var props = _.extend({}, properties, {
        token: this._token,
    });

    // Convert the payload to base64 JSON.
    var payload = btoa(JSON.stringify({
        event: eventName,
        properties: props,
    }));

    // Initiate the request.
    $.ajax({
        url: `${this._host}/track`,
        method: 'GET',
        cache: false, // appends _=time to the url
        data: {
            data: payload,
            ip: 1,
        },
    });
};

/**
 * Send a group of events to Mixpanel.
 *
 * @param {Array<{event:String, properties:Object}>} events
 */
MixpanelClient.prototype.trackEvents = function(events) {
    _.forEach(events, function(event) {
        this.trackEvent(event.event, event.properties);
    }, this);
};
