import * as Settings from '../settings';

/**
 * Spade Client
 * @class
 * @constructor
 *
 * @param {Object} opts
 *        `host`: Spade API host
 */
export function SpadeClient(opts) {
    this._host = opts.host;
}

/**
 * Send an event to Spade.
 *
 * @param {String} eventName
 * @param {Object} properties
 */
SpadeClient.prototype.trackEvent = function(eventName, properties) {
    if (_.contains(Settings.spadeIgnore, eventName)) {
        return;
    }

    this._send({
        event: eventName,
        properties: properties,
    });
};

/**
 * Send a group of events to Spade.
 *
 * @param {Array<{event:String, properties:Object}>} events
 */
SpadeClient.prototype.trackEvents = function(events) {
    var filteredEvents = _.filter(events, function(event) {
        return !_.contains(Settings.spadeIgnore, event.event);
    });

    if (filteredEvents.length > 0) {
        this._send(filteredEvents);
    }
};

/**
 * Send the tracking data to Spade.
 * @private
 *
 * @param {(Array|Object)} payload
 */
SpadeClient.prototype._send = function(payload) {
    $.ajax({
        url: this._host,
        method: 'POST',
        data: {
            data: btoa(JSON.stringify(payload)),
        },
    });
};
