import * as Settings from '../settings';

/**
 * Valve Client
 * Contacts the Steam Watching end-point to alert Valve when a
 * Steam user watches a Steam channel.
 *
 * @class
 * @constructor
 */
export function ValveClient() {
    this._viewerSteamId = Promise.reject();
    this._channelSteamId = Promise.reject();
}

/**
 * Sets the viewer info allocation promise.
 *
 * @param {Promise} data
 */
ValveClient.prototype.viewerInfo = function(data) {
    this._viewerSteamId = data.then(function(vi) {
        if (vi.steam_id) {
            return vi.steam_id;
        } else {
            return Promise.reject();
        }
    });
};

/**
 * Sets the channel info allocation promise.
 *
 * @param {Promise} data
 */
ValveClient.prototype.channelInfo = function(data) {
    this._channelSteamId = data.then(function(ci) {
        if (ci.steam_id) {
            return ci.steam_id;
        } else {
            return Promise.reject();
        }
    });
};

/**
 * Contacts the Steam Watching end-point to alert Valve when a
 * Steam user watches a Steam channel.
 */
ValveClient.prototype.notify = function() {
    // Ensure required data has been allocated before attempting to contact the API
    Promise.all([this._channelSteamId, this._viewerSteamId]).then(function(ids) {
        var channelSteamId = ids[0];
        var userSteamId = ids[1];

        $.ajax({
            url: Settings.valveApiHost,
            method: 'GET',
            data: {
                channel: channelSteamId,
                viewer: userSteamId,
            },
        });
    }).then(null, () => {
        // prevent this promise from spewing "Uncaught error (in promise)"
        // messages to the console
        return null;
    });
};
