/* eslint-disable no-unused-vars, no-undef */
// Empty backend used to define the Backend "interface".
//
// All methods are defined in the same order as the spec:
// http://dev.w3.org/html5/spec-author-view/video.html#mediaevents

import { flashError } from '../settings';
import EventEmitter from 'event-emitter';

export function BackendBlank() {
    'use strict';
    var self = this;

    var events = new EventEmitter();

    self.attach = function(element) {
        // unimplemented
    };

    self.destroy = function() {
        // unimplemented
    };

    self.addEventListener = function(name, func) {
        events.on(name, func);
    };

    self.removeEventListener = function(name, func) {
        events.off(name, func);
    };

    self.getError = function() {
        return flashError;
    };

    self.getSrc = function() {
        // unimplemented
    };

    self.setSrc = function(value) {
        // unimplemented
    };

    self.getCurrentSrc = function() {
        // unimplemented
    };

    self.NETWORK_EMPTY = 0;
    self.NETWORK_IDLE = 1;
    self.NETWORK_LOADING = 2;
    self.NETWORK_NO_SOURCE = 3;

    self.getNetworkState = function() {
        // unimplemented
    };

    self.getPreload = function() {
        // unimplemented
    };

    self.setPreload = function(value) {
        // unimplemented
    };

    self.getBuffered = function() {
        // unimplemented
    };

    self.load = function() {
        // unimplemented
    };

    self.HAVE_NOTHING = 0;
    self.HAVE_METADATA = 1;
    self.HAVE_CURRENT_DATA = 2;
    self.HAVE_FUTURE_DATA = 3;
    self.HAVE_ENOUGH_DATA = 4;

    self.getReadyState = function() {
        // unimplemented
    };

    self.getSeeking = function() {
        // unimplemented
    };

    self.getCurrentTime = function() {
        // unimplemented
    };

    self.setCurrentTime = function(value) {
        // unimplemented
    };

    self.getInitialTime = function() {
        // unimplemented
    };

    self.getDuration = function() {
        // unimplemented
    };

    self.getStartOffsetTime = function() {
        // unimplemented
    };

    self.getPaused = function() {
        // unimplemented
    };

    self.getDefaultPlaybackRate = function() {
        // unimplemented
    };

    self.setDefaultPlaybackRate = function(value) {
        // unimplemented
    };

    self.getPlaybackRate = function() {
        // unimplemented
    };

    self.setPlaybackRate = function(value) {
        // unimplemented
    };

    self.getPlayed = function() {
        // unimplemented
    };

    self.getSeekable = function() {
        // unimplemented
    };

    self.getEnded = function() {
        // unimplemented
    };

    self.getAutoplay = function() {
        // unimplemented
    };

    self.setAutoplay = function(value) {
        // unimplemented
    };

    self.getLoop = function() {
        // unimplemented
    };

    self.setLoop = function(value) {
        // unimplemented
    };

    self.play = function() {
        // unimplemented
    };

    self.pause = function() {
        // unimplemented
    };

    self.getControls = function() {
        // unimplemented
    };

    self.setControls = function(value) {
        // unimplemented
    };

    self.getVolume = function() {
        // unimplemented
    };

    self.setVolume = function(value) {
        // unimplemented
    };

    self.getMuted = function() {
        // unimplemented
    };

    self.setMuted = function(value) {
        // unimplemented
    };

    self.getDefaultMuted = function() {
        // unimplemented
    };

    self.setDefaultMuted = function(value) {
        // unimplemented
    };

    self.getQuality = function() {
        // unimplemented
    };

    self.setQuality = function(value) {
        // unimplemented
    };

    self.getQualities = function() {
        // unimplemented
    };

    self.getChannel = function() {
        // unimplemented
    };

    self.setChannel = function(value) {
        // unimplemented
    };

    self.getVideo = function() {
        // unimplemented
    };

    self.setVideo = function(value) {
        // unimplemented
    };

    self.getStats = function() {
        // unimplemented
    };

    self.getStatsEnabled = function() {
        // unimplemented
    };

    self.setStatsEnabled = function(value) {
        // unimplemented
    };

    self.getVideoInfo = function() {
        // unimplemented
    };

    self.getCaption = function() {
        // unimplemented
    };

    self.getBackend = function () {
        return 'blank';
    };
}
