import EventEmitter from 'event-emitter';
import { AdapterMse } from '../adapter/mse';
import { streamUrl } from '../api';

export function BackendMse() {
    var self = this;

    let events;
    let video;
    let adapter;

    let src;
    let channel;
    let videoId;
    let lastBuffer;

    var init = function() {
        events = new EventEmitter();
        video = document.createElement('video');
        adapter = new AdapterMse(video);

        events.emit('init');
    };

    // TODO Call when playing starts.
    var pollBuffer = function() {
        var buffer = self.getBuffered();
        if (buffer !== lastBuffer) {
            lastBuffer = buffer;
            events.emit('bufferchange');
        }

        setTimeout(pollBuffer, 1000);
    };

    self.attach = function(element) {
        element.appendChild(video);
    };

    self.dettach = function(element) {
        element.removeChild(video);
    };

    self.destroy = function() {
        adapter.destroy();
    };

    self.addEventListener = function(name, callback) {
        events.on(name, callback);
        video.addEventListener(name, callback);
    };

    self.removeEventListener = function(name, callback) {
        events.off(name, callback);
        video.removeEventListener(name, callback);
    };

    self.getNetworkProfile = function() {
        // TODO implement network profile collection for this backend
        return [];
    };

    self.getError = function() {
        return video.error;
    };

    self.getSrc = function() {
        return src;
    };

    self.setSrc = function(value) {
        src = value;

        if (src) {
            self.load();
        }
    };

    self.getCurrentSrc = function() {
        return src;
    };

    self.getCurrentSrc = function() {
        return video.currentSrc;
    };

    self.NETWORK_EMPTY = 0;
    self.NETWORK_IDLE = 1;
    self.NETWORK_LOADING = 2;
    self.NETWORK_NO_SOURCE = 3;

    self.getNetworkState = function() {
        return video.networkState;
    };

    self.getPreload = function() {
        return 'auto';
    };

    self.setPreload = function() {
        // TODO support changing preload
    };

    self.getBuffered = function() {
        return video.buffered;
    };

    self.load = function() {
        adapter.load(src);
    };

    self.HAVE_NOTHING = 0;
    self.HAVE_METADATA = 1;
    self.HAVE_CURRENT_DATA = 2;
    self.HAVE_FUTURE_DATA = 3;
    self.HAVE_ENOUGH_DATA = 4;

    self.getReadyState = function() {
        return video.readyState;
    };

    self.getSeeking = function() {
        return video.seeking;
    };

    self.getCurrentTime = function() {
        return video.currentTime;
    };

    self.setCurrentTime = function(value) {
        video.currentTime = value;
    };

    self.getInitialTime = function() {
        return video.initialTime;
    };

    self.getDuration = function() {
        return video.duration;
    };

    self.getStartOffsetTime = function() {
        return video.startOffsetTime;
    };

    self.getPaused = function() {
        return video.paused;
    };

    self.getDefaultPlaybackRate = function() {
        return video.defaultPlaybackRate;
    };

    self.setDefaultPlaybackRate = function(value) {
        video.defaultPlaybackRate = value;
    };

    self.getPlaybackRate = function() {
        return video.playbackRate;
    };

    self.setPlaybackRate = function(value) {
        video.playbackRate = value;
    };

    self.getPlayed = function() {
        return video.played;
    };

    self.getSeekable = function() {
        return video.seekable;
    };

    self.getEnded = function() {
        return video.ended;
    };

    self.getAutoplay = function() {
        return video.autoplay;
    };

    self.setAutoplay = function(value) {
        video.autoplay = value;
    };

    self.getLoop = function() {
        return video.loop;
    };

    self.setLoop = function(value) {
        video.loop = value;
    };

    self.play = function() {
        video.play();
    };

    self.pause = function() {
        video.pause();
    };

    self.getControls = function() {
        return video.controls;
    };

    self.setControls = function(value) {
        video.controls = value;
    };

    self.getPaused = function() {
        return video.paused;
    };

    self.setCurrentTime = function(value) {
        video.currentTime = value;
    };

    self.getVolume = function() {
        return video.volume;
    };

    self.setVolume = function(value) {
        video.volume = value;
    };

    self.getMuted = function() {
        return video.muted;
    };

    self.setMuted = function(value) {
        video.muted = value;
    };

    self.getDefaultMuted = function() {
        return video.defaultMuted;
    };

    self.setDefaultMuted = function(value) {
        video.defaultMuted = value;
    };

    self.getQuality = function() {
        return adapter.getQuality();
    };

    self.setQuality = function(value) {
        return adapter.setQuality(value);
    };

    self.getQualities = function() {
        return adapter.getQualities();
    };

    self.getChannel = function() {
        return channel;
    };

    self.setChannel = function(value) {
        var urlRequest = streamUrl('channel', value, {
            allow_source: true, // eslint-disable-line camelcase
        });

        channel = value;
        videoId = null;

        urlRequest.then(function(url) {
            self.setSrc(url);
            events.emit('loadedchannel');
        });
    };

    self.getVideo = function() {
        return videoId;
    };

    self.setVideo = function(value) {
        var urlRequest = streamUrl('video', value.substring(1), {
            allow_source: true, // eslint-disable-line camelcase
        });

        videoId = value;
        channel = null;

        urlRequest.then(function(url) {
            self.setSrc(url);
            events.emit('loadedvideo');
        });
    };

    self.getStats = function() {
        return {
            bufferSize: 0,
            displayResolution: '',
            skippedFrames: 0,
            fps: 0,
            hlsLatencyBroadcast: 0,
            hlsLatencyEncoder: 0,
            memoryUsage: 0,
            playbackRate: 0,
            playerVolume: 0,
            videoResolution: '',
        };
    };

    self.getStatsEnabled = function() {
        // unimplemented
    };

    self.setStatsEnabled = function() {
        // unimplemented
    };

    self.getCaption = function() {
        // unimplemented
    };

    self.getVideoInfo = function() {
        // TODO: unify in JS.
    };

    self.getBackend = function() {
        return 'mse';
    };

    self.getVersion = function() {
        // TODO
    };

    self.isSpectre = function() {
        // TODO
        return false;
    };

    init();
}

BackendMse.canPlay = function() {
    return AdapterMse.canPlay();
};
