import Client from 'minixperiment-client';
import ServiceProvider from 'minixperiment-client/lib/providers/service';

// Opts users in to network profile collection; some set of users will report
// segment-granularity bandwidth information (ttfb, bytes, download duration)
// for each segment downloaded during HLS playback.
export const NETWORK_PROFILE_COLLECTION = '5fbb67a0-b4ff-4775-b836-e9a348a87481';
// Experiment controlling the availability of ABS V1 "QuickStart", where the
// first segment loaded for a stream is of lower quality to improve time to
// first frame.
export const ABS_V1 = '424531b4-e23d-47d2-87c7-9b90a23ddd06';
// Experiment controlling the availability of preroll ads, where 1 percent
// of users will not have preroll ads.
export const PREROLL_ADS = '4e61c5c6-8cfb-485e-87f1-fc21c0d03068';
// Experiment for dark launch, controlling the retrieval of markers
export const MARKERS = 'afa3914d-3596-49da-92af-555e97c24171';

/**
 * Create an Minixperiment client with the provided options.
 *
 * @param {Object} options
 *        `deviceID`: The user's device ID
 *        `login`:    The user's login name (`null` if not logged in)
 * @return {Minixperiment.Client}
 */
export function createClient(options) {
    return new Client({
        defaults: {
            [NETWORK_PROFILE_COLLECTION]: 'no',
            [ABS_V1]: 'no',
            [PREROLL_ADS]: 'yes',
            [MARKERS]: 'no',
        },
        deviceID: options.deviceID,
        platform: 'web',
        // TODO do this correctly
        login: options.login,
        provider: new ServiceProvider(ServiceProvider.SERVICE_URL),
        Promise: Promise,
    });
}
