import * as Settings from './settings';

const KEY_CTRL = 17;
const KEY_SPACE = 32;
const KEY_PGUP = 33;
const KEY_PGDOWN = 34;
const KEY_UP = 38;
const KEY_DOWN = 40;
const KEY_LEFT = 37;
const KEY_RIGHT = 39;
const KEY_F = 70;
const MINIMUM_VOD_TIME = 0.01;

export function PlayerHotkeys(player, root, options) {
    var ctrl = false;
    var seekSeconds = function(seconds) {
        var channel = player.getChannel();
        var duration = player.getDuration();
        var currentTime = player.getCurrentTime();

        // Ignore live streams, non-seekable streams, and paused streams.
        if (channel || !_.isFinite(duration) || player.getPaused()) {
            return;
        }

        var targetTime = calculateTargetTime(currentTime, seconds, MINIMUM_VOD_TIME, duration, player.getEnded());

        if (targetTime) player.setCurrentTime(targetTime);
    };

    var calculateTargetTime = function(currentTime, seconds, min, max, ended) {
        // Ended VODs have currentTime equal to the last seeked time
        if (ended) {
            currentTime = max;
        }

        var value = currentTime + seconds;
        return (value < min ? min :
            value > max ? null :
            value);

    };

    root.setAttribute('tabindex', options.tabindex || -1);

    root.addEventListener('keydown', function(e) {
        var key = e.which || e.keyCode || e.charCode;
        var volume;

        if (key === KEY_CTRL) {
            ctrl = true;
        }

        if (key === KEY_SPACE) {
            // Space bar toggles pause.
            var paused = player.getPaused();
            if (paused) {
                player.play();
            } else {
                player.pause();
            }
        } else if (key === KEY_PGUP) {
            // Page up/down toggle muted.
            player.muted = false;
        } else if (key === KEY_PGDOWN) {
            player.muted = true;
        } else if (key === KEY_UP) {
            // Up/down keys change the volume 10%
            volume = player.getVolume();
            volume = Math.min(volume + Settings.volumeStepAmount, 1.0);

            player.setVolume(volume);
        } else if (key === KEY_DOWN) {
            volume = player.getVolume();
            volume = Math.max(volume - Settings.volumeStepAmount, 0.0);

            player.setVolume(volume);
        } else if (ctrl && key === KEY_F) {
            // ctrl+f toggles fullscreen.
            var fullscreen = player.getFullscreen();
            player.setFullscreen(!fullscreen);
        } else if (key === KEY_RIGHT) {
            seekSeconds(Settings.hotkeySeekAmount);
        } else if (key === KEY_LEFT) {
            seekSeconds(-Settings.hotkeySeekAmount);
        } else {
            // Avoid calling preventDefault if it wasn't a hotkey.
            return;
        }

        e.preventDefault();
    });

    root.addEventListener('keyup', function(e) {
        var key = e.which || e.keyCode || e.charCode;

        if (key === KEY_CTRL) {
            ctrl = false;
        }
    });
}
