import { parseUri } from './util/parseuri';

const TEST_PLAYER_AUTHORITY = 'testplayer.twitch.tv';

export const domain = 'twitch.tv';
export const twitchHost = '//twitch.tv';
export const apiHost = 'https://api.twitch.tv';
export const spectreHost = '//spectre.twitch.tv';
export const usherHost = '//usher.ttvnw.net';
export const valveApiHost = `${apiHost}/steam/watching`;
export const playerHost = (function() {
    // http://stackoverflow.com/questions/403967/how-may-i-reference-the-script-tag-that-loaded-the-currently-executing-script
    // Works on all modern browsers except IE...
    var script = document.currentScript;
    var scripts = document.getElementsByTagName('script');

    if (!script) {
        // Find any scripts ending with 'player.js' or 'player.*.js'
        var matches = _.filter(scripts, function(s) {
            return s.src && s.src.match(/player(?:\.\w+)?\.js$/i);
        });

        // If there are duplicates, we are very confused.
        if (matches.length === 1) {
            script = matches[0];
        } else {
            // Use the last script added to the page instead.
            // This will be our script UNLESS async was used (rare).
            script = scripts[scripts.length - 1];
        }
    }

    const uri = parseUri(script.src);
    // Special case the test environment; for those envs, we need to preserve
    // the non-root path to the player by inspecting the player.js script for
    // the branch name associated with the player.
    if (uri.authority === TEST_PLAYER_AUTHORITY) {
        const branchName = uri.path.split('/').slice(1, -2).join('/');
        return `${uri.protocol}://${uri.authority}/${branchName}`;
    }

    return `${uri.protocol}://${uri.authority}`;
})();

// Number of milliseconds to wait on an API request before giving up.
// This is important because we use JSONP and jQuery will ignore HTTP
// errors for cross-domain requests.
export const apiTimeout = 10000;

// Tracking
export const trackingPlatform = 'web';

export const mixpanelHost = '//api.mixpanel.com';
export const mixpanelToken = '809576468572134f909dffa6bd0dcfcf';
// QA mixpanel token; should only be enabled manually.
// export const mixpanelToken = '3857da20a3c2b03bb017825a6d1bce3e';
export const mixpanelIgnore = [
    'minute-buffered',
    'x_untrusted_video_init', // TODO Remove these events.
    'x_untrusted_video-play',
    'x_untrusted_minute-watched',
    'x_untrusted_buffer-empty',
    'x_untrusted_buffer-refill',
    'network_profile',
];

// spadeHost *must* be protocol relative for IE9's XDR to work correctly. XDR
// cannot make cross-protocol requests; only cross-domain is allowed.
export const spadeHost = '//spade.twitch.tv';
export const spadeIgnore = [];

export const countessHost = '//countess.twitch.tv';

export const gamePath = `${twitchHost}/directory/game`;

// Default popout size. 480p
export const popoutSize = {
    width: 853,
    height: 480,
};

export const chromecastId = '358E83DC';
export const version = '0.6.1';

// PubSub
export const pubSubEnviroment = 'production';

// Amount of time between polling for the current buffer size.
export const bufferPollDelay = 1000; // ms

export const qualityText = {
    chunked: 'Source',
    high: 'High',
    medium: 'Medium',
    low: 'Low',
    mobile: 'Mobile',
    auto: 'Auto',
};

// Show the quality change animation for 6 seconds.
export const qualityChangeDuration = 6000;

// Show the controls initially for 8 seconds.
export const initialControlsDelay = 8000; // ms

// Only show the controls for 5 seconds when hovering.
export const hoverControlsDelay = 5000; // ms

// Hide the menu 2 seconds after the user submits a video report.
export const reportHideDelay = 2000;

// http://dev.w3.org/html5/spec-author-view/video.html#mediaevents
export const mediaEvents = [
    'loadstart',
    'progress',
    'suspend',
    'abort',
    'error',
    'emptied',
    'stalled',
    'loadedmetadata',
    'loadeddata',
    'canplay',
    'canplaythrough',
    'playing',
    'waiting',
    'seeking',
    'seeked',
    'ended',
    'durationchange',
    'timeupdate',
    'play',
    'pause',
    'ratechange',
    'volumechange',
];

export const customEvents = [
    'adcompanionrendered',
    'castingchange',
    'bufferedchange',
    'statschange',
    'qualitychange',
    'qualitieschange',
    'adstart',
    'adend',
    'init',
    'loadedchannel',
    'loadedvideo',
    'viewerschange',
    'fullscreenchange',
    'restricted',
    'segmentchange',
    'isspectre',
    'theatrechange',
    'online',
    'offline',
    'usherfail',
    'captions',
];

export const allEvents = _.union(mediaEvents, customEvents);

export const debugIgnoreEvents = [
    'statschange',
    'timeupdate',
    'bufferedchange',
];

export const chromecastStates = [
    'unavailable',
    'available',
    'connecting',
    'connected',
    'error',
];

export const mutedSegmentsMessage = 'Audio for portions of this video has been muted as it appears to contain copyrighted content owned or controlled by a third party.';

export const embedParameters = [
    // public parameters; see
    // https://github.com/justintv/Twitch-API/blob/master/embed-video.md
    // specifies which channel to load in the embed
    'channel',
    // specifies which VOD to load in the embed
    'video',
    // whether the embed should begin playback in a default muted state
    'muted',
    // whether the embed should automatically begin playback when the content
    // stream loads
    'autoplay',
    // begin a VOD at the specified offset instead of the beginning
    'time',
    't', // alias of `time`, renamed for backwards compatibility
    // private parameters; these parameters must be available to third parties
    // such as Valve to ensure external integrations can set the correct value
    // for various properties

    // exposes additional debugging information via the JS console
    'debug',
    // forces html5 as the backend
    'html5',
    // forces the quality to the specified value
    'quality',
    // if the player controls (e.g. play/pause) should be displayed
    'controls',
    // if captions should be able to be displayed
    'captions',
];

// Each left/right key press increments or decrements the volume by 10%.
export const volumeStepAmount = 0.1;

// Maximum number of milliseconds to wait for the Flash IMA swf to load.
export const flashTimeout = 5000;

// VAST URL for DoubleClick advertisements.
export const doubleClickUrl = '//pubads.g.doubleclick.net/gampad/ads';

// To prevent load spikes, we show a confirmation box on exit.
// This is only shown for large channels that have recently gone offline.
export const leaveDialog = {
    // Controls whether we try to show the dialog or not.
    // Can be overwritten via options for testing (leaveDialogEnabled).
    enabled: false,

    // If the channel ended more than x seconds ago, don't show the dialog box.
    sinceEnded: 45,

    // If the channel has less than x viewers, don't show the box.
    // Can be overwritten via options for testing (leaveDialogViewerThreshold).
    viewerThreshold: 50000,

    // Actual text for the confirmation box (except for Firefox).
    text: 'Don\'t panicBasket. The broadcast is down, but don\'t refresh just yet. When the broadcast is back, the player will automatically reload for you.',

    // Consider the page load a refresh if it's been less than x seconds
    // since the dialog was shown to the user.
    refreshTimeout: 20,

    // Show the refresh warning overlay for x seconds.
    warningDuration: 45,
};

export const defaultLanguage = 'en-US';

// Seek amount in seconds on VODs with hotkeys
export const hotkeySeekAmount = 5;

// When we want to resume someone's VOD we don't want to force a resume if they would just end the VOD
// This is the number of seconds before the end of the VOD where it shouldn't resume
export const cancelResumeAmount = 10;

// TODO Move these strings to a localization service.
export const flashError = 'No supported video backend available; Flash is not installed';
export const channelError = 'Channel could not be found, or has been deleted by its owner';
export const videoError = 'Video could not be found, or has been deleted by its owner';
export const unknownError = 'An unknown error has occured';

// Date after which the cookie storing the last known quality for a user via
// HTTP will be automatically removed.
export const httpsQualityCarryover = new Date(2016, 3, 30);
