export const TEMPLATE_MARKER = {
    title: '',
    info: '',
    startTime: 0,
    imageURL: '',
    x: 0,
    y: 0,
    width: 0,
    height: 0,
};

// Assuming video ID's are appended on base URLs
const MARKER_JSON_BASE_URL = 'https://clipmn.twitch.tv/prod/';

// Game Types
const GAME_LEAGUE_OF_LEGEND = 'lol';
const GAME_HEARTHSTONE = 'hs';

// Tag Groups
const TAGS_LEAGUE_OF_LEGEND = 'leagueOfLegendTags';
const TAGS_HEARTHSTONE_OPENING = 'hearthStoneOpeningTags';
const TAGS_HEARTHSTONE_MATCH = 'hearthStoneMatchTags';
const TAGS_UNGROUPED = 'ungroupedTags';

// Marker Normalizing Function Maps
const MARKER_MAP = {
    [TAGS_LEAGUE_OF_LEGEND]: function(tag, index, data) {
        return {
            title: `Match ${index + 1}`,
            info: '',
            startTime: tag.start_sec,
            imageURL: `${MARKER_JSON_BASE_URL}${data.thumbnail_sheet}`,
            x: tag.thumbnail_index[1] * data.thumbnail_size[0],
            y: tag.thumbnail_index[0] * data.thumbnail_size[1],
            width: data.thumbnail_size[0],
            height: data.thumbnail_size[1],
        };
    },
    [TAGS_HEARTHSTONE_MATCH]: function(tag, index, data) {
        return {
            title: `Match ${index + 1}`,
            info: `<strong>${tag.game_data.characters[0]}</strong> vs. ${tag.game_data.characters[1]}`,
            startTime: tag.start_sec,
            // TODO: Remove dark launch logic
            imageURL: `${MARKER_JSON_BASE_URL}${data.thumbnail_sheet}?t=${Date.now()}`,
            x: tag.thumbnail_index[1] * data.thumbnail_size[0],
            y: tag.thumbnail_index[0] * data.thumbnail_size[1],
            width: data.thumbnail_size[0],
            height: data.thumbnail_size[1],
        };
    },
};

const DEFAULT_MARKER_MAP = () => null;

/**
 * Timeline Metadata
 * Retrieves and normalizes all info related to timeline enhancements.
 * Encompasses:
 * 1) Markers
 * 2) Thumbnail Previews (TODO : )
 * 3) Muted Segments (TODO : VP-403)
 * @class
 */
export class TimelineMetadata {
    constructor() {
    }

    /* eslint-disable no-unused-vars */
    getMarkers(videoID = '') {
        // return $.get(`${MARKER_JSON_BASE_URL}${videoID}.json`).
        // TODO: Dark Launch logic needs to be removed
        return $.get(`https://clipmn.twitch.tv/prod/v54109226.json?t=${Date.now()}`).
            then(json => JSON.parse(json)).
            then(this._normalizedMarkers, () => []);
    }
    /* eslint-enable no-unused-vars */

    _normalizedMarkers(rawMarkerData) {
        if (rawMarkerData === null) {
            return [];
        }

        const groupedTags = _.groupBy(rawMarkerData.data.tags, tag => {
            switch (tag.game_type) {
            case GAME_LEAGUE_OF_LEGEND:
                return TAGS_LEAGUE_OF_LEGEND;
            case GAME_HEARTHSTONE:
                switch (tag.game_data.type) {
                case 0:
                    return TAGS_HEARTHSTONE_MATCH;
                case 1:
                    return TAGS_HEARTHSTONE_OPENING;
                }
                break;
            }
            return TAGS_UNGROUPED;
        });

        return Array.prototype.concat.apply(
            [],
            _.values(
                _.mapObject(groupedTags, (group, groupName) => {
                    return group.map((tag, i) => {
                        const markerMapper = MARKER_MAP[groupName] || DEFAULT_MARKER_MAP;
                        return markerMapper(tag, i, rawMarkerData.data);
                    });
                })
            )
        ).filter(m => m !== null).sort();
    }
}
