import { EVENT_STATE_UPDATE } from '../state-tracker';

export class PlayerUIClosedCaption {
    constructor(state, root) {
        this._state = state;
        this._root = root;

        this._state.addEventListener(EVENT_STATE_UPDATE, this.handleEvent.bind(this));
        $('.js-control-cc', this._root).on('click', this.toggleCCStatus.bind(this));
    }

    handleEvent() {
        $('.js-player-captions').text(this.stringifyCaption());
        $('.js-control-cc').toggle(this._state.hasCaptions());
        $('.js-player-icon-cc').toggle(this._state.getCaptionsEnabled());
        $('.js-player-icon-cc-deactivated').toggle(!this._state.getCaptionsEnabled());
    }

    stringifyCaption() {
        var captionData = this._state.getCaption();
        if (captionData) {
            var captionsByCell = [];
            captionData.data.forEach(function (cell) {
                if (!captionsByCell[cell.row]) {
                    captionsByCell[cell.row] = [];
                }
                captionsByCell[cell.row].push(cell.char);
            });
            var captionsByRow = captionsByCell.map(function (row) {
                return row.join('');
            });
            return captionsByRow.join(' ');
        } else {
            return '';
        }
    }

    toggleCCStatus() {
        this._state.setCaptionsEnabled(!this._state.getCaptionsEnabled());
    }
}
