import { EVENT_LANGUAGE_CHANGED } from '../state-tracker';
import { qualityText } from '../settings';

export class PlayerUILang {
    constructor(root, state) {
        state.addEventListener(EVENT_LANGUAGE_CHANGED, state => {
            this.localizeUI(root, state.i18n);
        });
    }

    localizeUI(root, i18n) {

        // Translate text values
        const t = function (selector, string) {
            $(selector, root).text(i18n.translate(string));
        };

        t('.js-live-label', 'Live');
        t('.js-offline-label', 'Offline');
        t('.js-playlist-label', 'Playlist');
        t('.js-mature-warning-label', 'The broadcaster indicated that the channel is intended for mature audiences.');
        t('.js-mature-accept-label', 'Start Watching');
        t('.js-playing-on-label', 'Playing on');
        t('.js-close-label', 'Close');
        t('.js-subscribe-label', 'Subscribe');
        t('.js-playlist-started-label', ' has started a playlist.');
        t('.js-broadcast-down-label', 'The broadcast is down.');
        t('.js-broadcast-reload-label', 'The player will automatically reload when the broadcast is back.');
        t('.js-player-options-label', 'Player Options');
        t('.js-video-quality-label', 'Video Quality:');
        t('.js-popout-player', 'Popout Player');
        t('.js-stats-toggle', 'Show Video Stats');
        t('.js-copy-url', 'Copy Video URL at Current Time');
        t('.js-report-issue-label', 'Report Playback Issue');
        t('.js-select-label', 'Select');
        t('.js-audio-video-stutter-label', 'Audio and video stutter');
        t('.js-video-stutter-label', 'Video stutters, but audio is fine');
        t('.js-video-black-label', 'Video is completely black or doesn\'t load');
        t('.js-audio-video-desync-label', 'Audio and video aren\'t synced');
        t('.js-fullscreen-not-working-label', 'Fullscreen playback doesn\'t work');
        t('.js-ad-too-loud-label', 'Advertisement can\'t be muted or is too loud');
        t('.js-ad-too-often-label', 'Advertisement has played too many times');
        t('.js-submit-label', 'Submit');
        t('.js-report-thanks-label', 'Thanks for your report');
        t('.js-coming-up-label', 'Coming Up');
        t('.js-advertisement-label', 'Advertisement');
        t('.js-now-playing-label', 'Now playing: ');
        t('.js-playing-label', 'playing ');
        t('.js-for-label', 'for');

        const numViewers = Number($('.js-meta-viewers').text());
        if (numViewers) {
            $('.js-viewers-label').text = i18n.translate(' viewer', {
                count: numViewers,
            });
        }

        // Translate Attribute Values
        const tAttr = function (selector, attr, string) {
            $(selector).attr(attr, i18n.translate(string));
        };

        tAttr('.js-control-playpause-button .js-pause-button .js-tip', 'data-tip', 'Pause');
        tAttr('.js-control-playpause-button .js-play-button .js-tip', 'data-tip', 'Play');
        tAttr('.js-control-volume .js-mute .js-control-tip', 'data-tip', 'Mute');
        tAttr('.js-control-volume .js-unmute .js-control-tip', 'data-tip', 'Unmute');
        tAttr('.js-menu-button .js-tip', 'data-tip', 'Options');
        tAttr('.js-control-cc .js-tip', 'data-tip', 'Captions');
        tAttr('.js-control-fullscreen .js-fullscreen .js-control-tip', 'data-tip', 'Fullscreen');
        tAttr('.js-control-fullscreen .js-exit-fullscreen .js-control-tip', 'data-tip', 'Exit Fullscreen');
        tAttr('.js-chromecast-btuton .js-tip', 'data-tip', 'Chromecast');
        tAttr('.js-watch-twitch .js-tip', 'data-tip', 'Watch on Twitch');

        $('.js-quality').children('option').each((index, option) => {
            const text = qualityText[$(option).val()];
            $(option).text(i18n.translate(text));
        });
    }

    /**
     *
     */
    destroy() {

    }
}
