import { PlayerUIState } from './state';
import { PlayerUIControls } from './controls';
import { PlayerUIInfo } from './info';
import { PlayerUISeek } from './seek';
import { PlayerUIStats } from './stats';
import { PlayerUIUpnext } from './upnext';
import { PlayerUILeaveDialog } from './leave-dialog';
import { PlayerUISubscribeOverlay } from './subscribe-overlay';
import { PlayerUIResume } from './resume-vod';
import { PlayerUISeekBarMarkers } from './seekbar-markers';
import { PlayerUILang } from './lang';
import { PlayerUIClosedCaption } from './closed-caption';

export function PlayerUI(player, root, analytics, experiments, state, options) {
    let uiState;
    let uiControls;
    let uiInfo;
    let uiSeek;
    let uiStats;
    let uiUpNext;
    let uiLeaveDialog;
    let uiLang;
    let uiSubscribeOverlay;
    let uiResume;
    let uiSeekBarMarkers;

    var init = function() {
        // Backwards compatibility until we can change web.
        options = _.defaults(options, {
            showInfo: options.channelInfo,
        });

        options = _.defaults(options, {
            branding: true,
            showInfo: true,
        });

        // TODO: Remove when captions go live
        options = _.defaults(options, {
            captions: false,
        });

        // Root DOM element.
        $(root).addClass('player');

        // Append the HTML to the DOM.
        $(root).append(require('html!../../html/player.html'));

        // Now we can initialize the subcomponents.
        uiState = new PlayerUIState(root, state);
        uiControls = new PlayerUIControls(player, root, state, analytics, options);
        uiInfo = new PlayerUIInfo(player, root, state, options);
        uiSeek = new PlayerUISeek(player, root, state);
        uiStats = new PlayerUIStats(root, state);
        uiUpNext = new PlayerUIUpnext(player, root, state);
        uiLeaveDialog = new PlayerUILeaveDialog(player, root, analytics, state, options);
        uiLang = new PlayerUILang(root, state);
        uiSubscribeOverlay = new PlayerUISubscribeOverlay(root, state);
        uiResume = new PlayerUIResume(player, state, options);
        uiSeekBarMarkers = new PlayerUISeekBarMarkers(player, root, state);

        // TODO: Remove conditional when captions go live
        if (options.captions) {
            new PlayerUIClosedCaption(state, root);
        }

        $(root).attr('data-initializing', true);

        player.addEventListener('init', function() {
            $(root).attr('data-initializing', false);
        });
    };

    this.destroy = function() {
        uiState.destroy();
        uiControls.destroy();
        uiInfo.destroy();
        uiSeek.destroy();
        uiStats.destroy();
        uiUpNext.destroy();
        uiLeaveDialog.destroy();
        uiLang.destroy();
        uiSubscribeOverlay.destroy();
        uiResume.destroy();
        uiSeekBarMarkers.destroy();
    };

    init();
}
