import * as Settings from '../settings';
import { EVENT_PLAYER_UPDATE } from '../state-tracker';

// THIS FUNCTIONALITY SHOULD BE MOVED INTO THE CONTROLLER

export class PlayerUIResume {
    constructor(player, state, options) {
        this._state = state;
        this._player = player;
        this._options = options;
        this._state.addEventListener(EVENT_PLAYER_UPDATE, this.handleEvent.bind(this));
    }

    handleEvent(event) {
        if (this._state.channelName) {
            return;
        }

        switch (event) {
        case 'loadedmetadata':
            this._onLoadedMetadata();
            break;
        case 'timeupdate':
            this._onTimeUpdate();
            break;
        }
    }

    _onLoadedMetadata() {
        const resumeTime = this._getResumeTime(this._state.videoID);

        if (this._options.time === null && _.isNumber(resumeTime)) {
            this._player.setCurrentTime(resumeTime);
        }
    }

    _onTimeUpdate() {
        if (!this._state.duration) {
            return;
        }

        if ((this._state.duration - this._state.currentTime) > Settings.cancelResumeAmount) {
            this._setResumeTime(this._state.currentTime, this._state.videoID);
            this._setResumeWatched(this._state.videoID);
        } else {
            this._cancelResumeTime(this._state.videoID);
        }
    }

    _getResumeTime(videoID) {
        return this._state.vodResumeTimes[videoID];
    }

    _setResumeTime(time, videoID) {
        const resumeTimes = this._state.vodResumeTimes;
        resumeTimes[videoID] = time;
        this._state.setVodResumeTimes(resumeTimes);
    }

    // TODO : resumeWatched will be removed when web client finishes testing with it
    _setResumeWatched(videoID) {
        const resumeWatcheds = this._state.vodResumeWatcheds;
        resumeWatcheds[videoID] = true;
        this._state.setVodResumeWatcheds(resumeWatcheds);
    }

    _cancelResumeTime(videoID) {
        const resumeTimes = this._state.vodResumeTimes;
        if (resumeTimes.hasOwnProperty(videoID)) {
            delete resumeTimes[videoID];
        }
        this._state.setVodResumeTimes(resumeTimes);
    }

    /**
     *
     */
    destroy() {}
}
